/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.remote.management;

import java.util.HashSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.eclipse.team.svn.core.operation.remote.management.AddRevisionLinkOperation;
import org.eclipse.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRevisionLink;
import org.eclipse.team.svn.core.resource.IRevisionLinkProvider;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.operation.RefreshRepositoryLocationsOperation;
import org.eclipse.team.svn.ui.panel.common.InputRevisionPanel;

public class SelectResourceRevisionAction
extends AbstractRepositoryTeamAction {
    public void runImpl(IAction action) {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        this.runImpl(resources);
    }

    protected void runImpl(IRepositoryResource[] resources) {
        IActionOperation op = SelectResourceRevisionAction.getAddRevisionLinkOperation(resources, this.getShell());
        if (op != null) {
            this.runScheduled(op);
        }
    }

    public static IActionOperation getAddRevisionLinkOperation(IRepositoryResource[] resources, Shell shell) {
        SVNRevision selectedRevision = null;
        final String[] comment = new String[1];
        InputRevisionPanel panel = new InputRevisionPanel(resources.length == 1 ? resources[0] : null, false, null);
        DefaultDialog dialog = new DefaultDialog(shell, panel);
        if (dialog.open() == 0) {
            comment[0] = panel.getRevisionComment();
            if (resources.length == 1) {
                selectedRevision = panel.getSelectedRevision();
                resources[0] = SVNUtility.copyOf((IRepositoryResource)resources[0]);
                resources[0].setSelectedRevision(selectedRevision);
            }
            final LocateResourceURLInHistoryOperation locateOp = new LocateResourceURLInHistoryOperation(resources);
            AddRevisionLinkOperation mainOp = new AddRevisionLinkOperation(new IRevisionLinkProvider(){

                public IRevisionLink[] getRevisionLinks() {
                    IRepositoryResource[] resources = locateOp.getRepositoryResources();
                    IRevisionLink[] links = new IRevisionLink[resources.length];
                    int i = 0;
                    while (i < resources.length) {
                        links[i] = SVNUtility.createRevisionLink((IRepositoryResource)resources[i]);
                        links[i].setComment(comment[0]);
                        ++i;
                    }
                    return links;
                }
            }, selectedRevision);
            CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
            op.add((IActionOperation)locateOp);
            op.add((IActionOperation)mainOp, new IActionOperation[]{locateOp});
            op.add((IActionOperation)new SaveRepositoryLocationsOperation());
            HashSet<IRepositoryLocation> locations = new HashSet<IRepositoryLocation>();
            IRepositoryResource[] iRepositoryResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IRepositoryResource resource = iRepositoryResourceArray[n2];
                locations.add(resource.getRepositoryLocation());
                ++n2;
            }
            op.add((IActionOperation)new RefreshRepositoryLocationsOperation(locations.toArray(new IRepositoryLocation[locations.size()]), true));
            return op;
        }
        return null;
    }

    public boolean isEnabled() {
        return this.getSelectedRepositoryResources().length > 0;
    }
}

