/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.segmentstore.core.arraylist;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;

public class LazyArrayListStore<@NonNull E extends ISegment>
implements ISegmentStore<E> {
    protected final Comparator<E> COMPARATOR = Comparator.comparing(IHTInterval::getStart).thenComparing(IHTInterval::getEnd).thenComparing(Function.identity());
    private final ReentrantLock fLock = new ReentrantLock(false);
    protected final List<E> fStore;
    private transient @Nullable Iterable<E> fLastSnapshot = null;
    private volatile boolean fDirty = false;
    private volatile long fStart = Long.MAX_VALUE;
    private volatile long fEnd = Long.MIN_VALUE;

    public LazyArrayListStore() {
        this.fStore = new ArrayList();
    }

    public LazyArrayListStore(Object[] array) {
        this.fStore = new ArrayList(array.length);
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof ISegment) {
                ISegment element = (ISegment)object;
                this.setDirtyIfNeeded(element);
                this.fStore.add(element);
                this.fStart = Math.min(this.fStart, element.getStart());
                this.fEnd = Math.max(this.fEnd, element.getEnd());
            }
            ++n2;
        }
        if (this.fDirty) {
            this.sortStore();
        }
    }

    protected void setDirtyIfNeeded(@NonNull E value) {
        if (!this.fStore.isEmpty() && this.COMPARATOR.compare((ISegment)this.fStore.get(this.size() - 1), value) > 0) {
            this.fDirty = true;
        }
    }

    @Override
    public Iterator<E> iterator() {
        this.fLock.lock();
        try {
            ImmutableList lastSnapshot;
            if (this.fDirty) {
                this.sortStore();
            }
            if ((lastSnapshot = this.fLastSnapshot) == null) {
                this.fLastSnapshot = lastSnapshot = ImmutableList.copyOf(this.fStore);
            }
            Iterator iterator = (Iterator)NonNullUtils.checkNotNull(lastSnapshot.iterator());
            return iterator;
        }
        finally {
            this.fLock.unlock();
        }
    }

    protected void sortStore() {
        this.fStore.sort(this.COMPARATOR);
        this.fDirty = false;
    }

    @Override
    public boolean add(@Nullable E val) {
        if (val == null) {
            throw new IllegalArgumentException("Cannot add null value");
        }
        this.fLock.lock();
        try {
            this.setDirtyIfNeeded(val);
            this.fStore.add(this.getInsertionPoint(val), val);
            this.fLastSnapshot = null;
            this.fStart = Math.min(this.fStart, val.getStart());
            this.fEnd = Math.max(this.fEnd, val.getEnd());
            return true;
        }
        finally {
            this.fLock.unlock();
        }
    }

    protected int getInsertionPoint(E value) {
        return this.fStore.size();
    }

    @Override
    public int size() {
        this.fLock.lock();
        try {
            int n = this.fStore.size();
            return n;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.fLock.lock();
        try {
            boolean bl = this.fStore.isEmpty();
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public boolean contains(@Nullable Object o) {
        this.fLock.lock();
        try {
            boolean bl = this.fStore.contains(o);
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public boolean containsAll(@Nullable Collection<?> c) {
        this.fLock.lock();
        try {
            boolean bl = this.fStore.containsAll(c);
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        this.fLock.lock();
        try {
            if (this.fDirty) {
                this.sortStore();
            }
            Object[] objectArray = this.fStore.toArray();
            return objectArray;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.fLock.lock();
        try {
            if (this.fDirty) {
                this.sortStore();
            }
            T[] TArray = this.fStore.toArray(a);
            return TArray;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public boolean addAll(@Nullable Collection<? extends E> c) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        this.fLock.lock();
        try {
            c.forEach(this::add);
            return true;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void clear() {
        this.fLock.lock();
        try {
            this.fStore.clear();
            this.fLastSnapshot = null;
            this.fDirty = false;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public Iterable<E> getIntersectingElements(long start, long end) {
        this.fLock.lock();
        if (this.fDirty) {
            this.sortStore();
        }
        try {
            if (start <= this.fStart && end >= this.fEnd) {
                ImmutableList lastSnapshot = this.fLastSnapshot;
                if (lastSnapshot == null) {
                    this.fLastSnapshot = lastSnapshot = ImmutableList.copyOf(this.fStore);
                }
                Iterable iterable = (Iterable)NonNullUtils.checkNotNull(lastSnapshot);
                return iterable;
            }
            int arraySize = Collections.binarySearch(this.fStore, new BasicSegment(end, Long.MAX_VALUE));
            arraySize = arraySize >= 0 ? arraySize + 1 : -arraySize;
            ArrayList<ISegment> iterable = null;
            for (ISegment seg : this.fStore) {
                if (seg.getStart() <= end && seg.getEnd() >= start) {
                    if (iterable == null) {
                        iterable = new ArrayList<ISegment>(arraySize);
                    }
                    iterable.add(seg);
                } else if (seg.getStart() > end) break;
                --arraySize;
            }
            if (iterable != null) {
                iterable.trimToSize();
                ArrayList<ISegment> arrayList = iterable;
                return arrayList;
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void dispose() {
        this.clear();
    }
}

