/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.statesystem.mipmap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.mipmap.TimeRange;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public final class TmfStateSystemOperations {
    private TmfStateSystemOperations() {
    }

    public static ITmfStateValue queryRangeMax(ITmfStateSystem ss, long t1, long t2, int quark) throws AttributeNotFoundException, TimeRangeException, StateValueTypeException {
        TmfStateValue max = TmfStateValue.nullValue();
        List<ITmfStateInterval> intervals = TmfStateSystemOperations.queryAttributeRange(ss, t1, t2, quark, "max");
        if (intervals.size() == 0) {
            return TmfStateValue.nullValue();
        }
        block4: for (ITmfStateInterval si : intervals) {
            ITmfStateValue value = si.getStateValue();
            switch (value.getType()) {
                case DOUBLE: {
                    if (!max.isNull() && !(si.getStateValue().unboxDouble() > max.unboxDouble())) continue block4;
                    max = si.getStateValue();
                    break;
                }
                case INTEGER: 
                case LONG: {
                    if (!max.isNull() && si.getStateValue().unboxLong() <= max.unboxLong()) continue block4;
                    max = si.getStateValue();
                    break;
                }
                default: {
                    throw new StateValueTypeException(String.valueOf(ss.getSSID()) + " Quark:" + quark + ", Type:" + value.getType());
                }
            }
        }
        return max;
    }

    public static ITmfStateValue queryRangeMin(ITmfStateSystem ss, long t1, long t2, int quark) throws AttributeNotFoundException, TimeRangeException, StateValueTypeException {
        TmfStateValue min = TmfStateValue.nullValue();
        List<ITmfStateInterval> intervals = TmfStateSystemOperations.queryAttributeRange(ss, t1, t2, quark, "min");
        if (intervals.size() == 0) {
            return TmfStateValue.nullValue();
        }
        block4: for (ITmfStateInterval si : intervals) {
            ITmfStateValue value = si.getStateValue();
            switch (value.getType()) {
                case DOUBLE: {
                    if (!min.isNull() && !(si.getStateValue().unboxDouble() < min.unboxDouble())) continue block4;
                    min = si.getStateValue();
                    break;
                }
                case INTEGER: 
                case LONG: {
                    if (!min.isNull() && si.getStateValue().unboxLong() >= min.unboxLong()) continue block4;
                    min = si.getStateValue();
                    break;
                }
                default: {
                    throw new StateValueTypeException(String.valueOf(ss.getSSID()) + " Quark:" + quark + ", Type:" + value.getType());
                }
            }
        }
        return min;
    }

    public static double queryRangeAverage(ITmfStateSystem ss, long t1, long t2, int quark) throws AttributeNotFoundException, TimeRangeException, StateValueTypeException {
        double avg = 0.0;
        List<ITmfStateInterval> intervals = TmfStateSystemOperations.queryAttributeRange(ss, t1, t2, quark, "avg");
        if (intervals.size() == 0) {
            return 0.0;
        }
        if (t1 == t2) {
            ITmfStateValue value = intervals.get(0).getStateValue();
            if (value.getType() == ITmfStateValue.Type.DOUBLE) {
                return value.unboxDouble();
            }
            return value.unboxLong();
        }
        for (ITmfStateInterval si : intervals) {
            long startTime = Math.max(t1, si.getStartTime());
            long endTime = Math.min(t2, si.getEndTime() + 1L);
            long delta = endTime - startTime;
            if (delta <= 0L) continue;
            ITmfStateValue value = si.getStateValue();
            if (value.getType() == ITmfStateValue.Type.DOUBLE) {
                avg += si.getStateValue().unboxDouble() * ((double)delta / (double)(t2 - t1));
                continue;
            }
            avg += (double)si.getStateValue().unboxLong() * ((double)delta / (double)(t2 - t1));
        }
        return avg;
    }

    /*
     * Unable to fully structure code
     */
    private static List<ITmfStateInterval> queryAttributeRange(ITmfStateSystem ss, long t1, long t2, int baseQuark, String featureString) throws AttributeNotFoundException, TimeRangeException, StateValueTypeException {
        timeRange = new TimeRange(t1, t2);
        mipmapQuark = -1;
        intervals = new ArrayList<ITmfStateInterval>();
        try {
            block8: {
                block9: {
                    try {
                        mipmapQuark = ss.getQuarkRelative(baseQuark, new String[]{featureString});
                        break block8;
                    }
                    catch (AttributeNotFoundException e) {
                        if (t1 == t2) {
                            interval = ss.querySingleState(t1, baseQuark);
                            if (!interval.getStateValue().isNull()) {
                                intervals.add(interval);
                            }
                            break block9;
                        }
                        ** for (interval : StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)baseQuark, (long)t1, (long)t2))
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (interval.getStateValue().isNull()) continue;
                        intervals.add(interval);
                        continue;
                    }
                }
                return intervals;
            }
            maxLevelInterval = ss.querySingleState(timeRange.getSecond(), mipmapQuark);
            levelMax = maxLevelInterval.getStateValue().unboxInt();
            TmfStateSystemOperations.queryMipmapAttributeRange(ss, 0, levelMax, baseQuark, mipmapQuark, timeRange, intervals);
            return intervals;
        }
        catch (StateValueTypeException e) {
            throw new StateValueTypeException("State system advertises mipmaps, but doesn't actually have them.", (Throwable)e);
        }
        catch (StateSystemDisposedException var10_11) {
            return intervals;
        }
    }

    private static void queryMipmapAttributeRange(ITmfStateSystem ss, int currentLevel, int levelMax, int baseQuark, int mipmapQuark, TimeRange timeRange, List<ITmfStateInterval> intervals) throws AttributeNotFoundException, TimeRangeException {
        int level = currentLevel;
        TimeRange range = timeRange;
        ITmfStateInterval currentLevelInterval = null;
        ITmfStateInterval nextLevelInterval = null;
        if (range == null || range.getFirst() > range.getSecond()) {
            return;
        }
        if (level > levelMax || level < 0) {
            return;
        }
        try {
            int levelQuark;
            if (range.getFirst() == range.getSecond()) {
                level = 0;
                currentLevelInterval = ss.querySingleState(range.getFirst(), baseQuark);
                if (!currentLevelInterval.getStateValue().isNull()) {
                    intervals.add(currentLevelInterval);
                }
                return;
            }
            if (level < levelMax) {
                levelQuark = ss.getQuarkRelative(mipmapQuark, new String[]{String.valueOf(level + 1)});
                nextLevelInterval = ss.querySingleState(range.getFirst(), levelQuark);
            }
            if (nextLevelInterval != null && TmfStateSystemOperations.isFullyOverlapped(range, nextLevelInterval)) {
                if (nextLevelInterval.getStateValue().isNull()) {
                    range = TmfStateSystemOperations.updateTimeRange(range, nextLevelInterval);
                } else {
                    ++level;
                }
                TmfStateSystemOperations.queryMipmapAttributeRange(ss, level, levelMax, baseQuark, mipmapQuark, range, intervals);
                return;
            }
            if (level == 0) {
                currentLevelInterval = ss.querySingleState(range.getFirst(), baseQuark);
            } else {
                levelQuark = ss.getQuarkRelative(mipmapQuark, new String[]{String.valueOf(level)});
                currentLevelInterval = ss.querySingleState(range.getFirst(), levelQuark);
            }
            if (TmfStateSystemOperations.isFullyOverlapped(range, currentLevelInterval)) {
                if (!currentLevelInterval.getStateValue().isNull()) {
                    intervals.add(currentLevelInterval);
                }
                range = TmfStateSystemOperations.updateTimeRange(range, currentLevelInterval);
            } else if (level == 0) {
                if (!currentLevelInterval.getStateValue().isNull()) {
                    intervals.add(currentLevelInterval);
                }
                range = TmfStateSystemOperations.updateTimeRange(range, currentLevelInterval);
            } else {
                --level;
            }
            TmfStateSystemOperations.queryMipmapAttributeRange(ss, level, levelMax, baseQuark, mipmapQuark, range, intervals);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
    }

    private static TimeRange updateTimeRange(TimeRange timeRange, ITmfStateInterval currentLevelInterval) {
        if (currentLevelInterval.getEndTime() >= timeRange.getSecond()) {
            return null;
        }
        long startTime = Math.max(timeRange.getFirst(), Math.min(currentLevelInterval.getEndTime() + 1L, timeRange.getSecond()));
        return new TimeRange(startTime, timeRange.getSecond());
    }

    private static boolean isFullyOverlapped(TimeRange range, ITmfStateInterval interval) {
        if (range.getFirst() >= range.getSecond() || interval.getStartTime() >= interval.getEndTime()) {
            return false;
        }
        return range.getFirst() <= interval.getStartTime() && range.getSecond() >= interval.getEndTime();
    }
}

