/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.rap.rwt.internal.RWTProperties;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceHandlerRegistry;
import org.eclipse.rap.rwt.internal.service.UISessionImpl;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.eclipse.rap.rwt.service.ServiceManager;
import org.eclipse.rap.rwt.service.UISession;

public class ServiceManagerImpl
implements ServiceManager {
    public static final String REQUEST_PARAM = "servicehandler";
    private final ServiceHandler defaultHandler;
    private final ServiceHandlerRegistry customHandlers;

    public ServiceManagerImpl(ServiceHandler defaultServieHandler) {
        this.defaultHandler = defaultServieHandler;
        this.customHandlers = new ServiceHandlerRegistry();
    }

    public ServiceHandler getServiceHandler(String customId) {
        return this.customHandlers.get(customId);
    }

    @Override
    public void registerServiceHandler(String id, ServiceHandler handler) {
        ParamCheck.notNullOrEmpty(id, "id");
        ParamCheck.notNull(handler, "handler");
        if (!this.customHandlers.put(id, handler)) {
            String message = "A service handler is already registered with this id: " + id;
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public void unregisterServiceHandler(String id) {
        ParamCheck.notNullOrEmpty(id, "id");
        this.customHandlers.remove(id);
    }

    @Override
    public String getServiceHandlerUrl(String id) {
        ParamCheck.notNull(id, "id");
        HttpServletRequest request = ContextProvider.getRequest();
        StringBuilder url = new StringBuilder();
        String baseUrl = RWTProperties.getServiceHandlerBaseUrl();
        if (baseUrl != null) {
            url.append(baseUrl);
        }
        if (!RWTProperties.isUseRelativeURL()) {
            url.append(request.getRequestURI());
        }
        url.append('?').append(REQUEST_PARAM).append('=').append(ServiceManagerImpl.encodeParameter(id));
        String connectionId = ServiceManagerImpl.getConnectionId();
        if (connectionId != null) {
            url.append('&').append("cid").append('=').append(connectionId);
        }
        return ContextProvider.getResponse().encodeURL(url.toString());
    }

    public void clear() {
        this.customHandlers.clear();
    }

    public ServiceHandler getHandler() {
        String customId = ServiceManagerImpl.getCustomHandlerId();
        ServiceHandler result = customId != null && customId.length() > 0 ? this.getCustomHandlerChecked(customId) : this.defaultHandler;
        return result;
    }

    private ServiceHandler getCustomHandlerChecked(String customId) {
        ServiceHandler customHandler = this.customHandlers.get(customId);
        if (customHandler == null) {
            throw new IllegalArgumentException("No service handler registered with id " + customId);
        }
        return customHandler;
    }

    private static String getCustomHandlerId() {
        return ContextProvider.getRequest().getParameter(REQUEST_PARAM);
    }

    private static String getConnectionId() {
        UISession uiSession = ContextProvider.getUISession();
        return uiSession == null ? null : ((UISessionImpl)uiSession).getConnectionId();
    }

    private static String encodeParameter(String id) {
        try {
            return URLEncoder.encode(id, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException(exception);
        }
    }
}

