/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.runner.junit3;

import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import org.eclipse.jdt.internal.junit.runner.IClassifiesThrowables;
import org.eclipse.jdt.internal.junit.runner.IListensToTestExecutions;
import org.eclipse.jdt.internal.junit.runner.ITestIdentifier;
import org.eclipse.jdt.internal.junit.runner.TestExecution;
import org.eclipse.jdt.internal.junit.runner.junit3.JUnit3TestReference;

public class JUnit3Listener
implements TestListener {
    private final IListensToTestExecutions fNotified;
    private final IClassifiesThrowables fClassifier;

    public JUnit3Listener(TestExecution execution) {
        this.fNotified = execution.getListener();
        this.fClassifier = execution.getClassifier();
    }

    public void startTest(Test test) {
        this.fNotified.notifyTestStarted(this.id(test));
    }

    public void addError(Test test, Throwable throwable) {
        this.newReference(test).sendFailure(throwable, this.fClassifier, "%ERROR  ", this.fNotified);
    }

    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.newReference(test).sendFailure((Throwable)assertionFailedError, this.fClassifier, "%FAILED ", this.fNotified);
    }

    public void endTest(Test test) {
        this.fNotified.notifyTestEnded(this.id(test));
    }

    private ITestIdentifier id(Test test) {
        return this.newReference(test).getIdentifier();
    }

    private JUnit3TestReference newReference(Test test) {
        return new JUnit3TestReference(test);
    }
}

