/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.logging;

import java.io.PrintStream;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.jetty.logging.JettyAppender;
import org.eclipse.jetty.logging.JettyLogger;
import org.eclipse.jetty.logging.JettyLoggerConfiguration;
import org.eclipse.jetty.logging.Timestamp;
import org.slf4j.event.Level;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class StdErrAppender
implements JettyAppender {
    static final String NAME_CONDENSE_KEY = "org.eclipse.jetty.logging.appender.NAME_CONDENSE";
    static final String MESSAGE_ALIGN_KEY = "org.eclipse.jetty.logging.appender.MESSAGE_ALIGN";
    static final String MESSAGE_ESCAPE_KEY = "org.eclipse.jetty.logging.appender.MESSAGE_ESCAPE";
    static final String ZONEID_KEY = "org.eclipse.jetty.logging.appender.ZONE_ID";
    private static final String EOL = System.lineSeparator();
    private final Timestamp timestamper;
    private final boolean condensedNames;
    private final boolean escapedMessages;
    private final int messageAlignColumn;
    private PrintStream stream;

    public StdErrAppender(JettyLoggerConfiguration config) {
        this(config, null);
    }

    public StdErrAppender(JettyLoggerConfiguration config, PrintStream stream) {
        this(config, stream, null);
    }

    public StdErrAppender(JettyLoggerConfiguration config, PrintStream stream, TimeZone timeZone) {
        Objects.requireNonNull(config, "JettyLoggerConfiguration");
        this.stream = stream;
        TimeZone tzone = timeZone;
        if (tzone == null && (tzone = config.getTimeZone(ZONEID_KEY)) == null) {
            tzone = TimeZone.getDefault();
        }
        this.timestamper = new Timestamp(tzone);
        this.condensedNames = config.getBoolean(NAME_CONDENSE_KEY, true);
        this.escapedMessages = config.getBoolean(MESSAGE_ESCAPE_KEY, true);
        this.messageAlignColumn = config.getInt(MESSAGE_ALIGN_KEY, 0);
    }

    @Override
    public void emit(JettyLogger logger, Level level, long timestamp, String threadName, Throwable throwable, String message, Object ... argumentArray) {
        StringBuilder builder = new StringBuilder(64);
        this.format(builder, logger, level, timestamp, threadName, throwable, message, argumentArray);
        if (this.stream != null) {
            this.stream.println(builder);
        } else {
            System.err.println(builder);
        }
    }

    public boolean isCondensedNames() {
        return this.condensedNames;
    }

    public boolean isEscapedMessages() {
        return this.escapedMessages;
    }

    public int getMessageAlignColumn() {
        return this.messageAlignColumn;
    }

    public PrintStream getStream() {
        return this.stream;
    }

    public void setStream(PrintStream stream) {
        this.stream = stream;
    }

    private void format(StringBuilder builder, JettyLogger logger, Level level, long timestamp, String threadName, Throwable throwable, String message, Object ... argumentArray) {
        Throwable cause = throwable;
        this.timestamper.formatNow(timestamp, builder);
        builder.append(':').append(this.renderedLevel(level));
        builder.append(':');
        if (this.condensedNames) {
            builder.append(logger.getCondensedName());
        } else {
            builder.append(logger.getName());
        }
        builder.append(':');
        builder.append(threadName);
        builder.append(':');
        int padAmount = this.messageAlignColumn - builder.length();
        if (padAmount > 0) {
            builder.append(" ".repeat(padAmount));
        } else {
            builder.append(' ');
        }
        FormattingTuple ft = MessageFormatter.arrayFormat((String)message, (Object[])argumentArray);
        this.appendEscaped(builder, ft.getMessage());
        if (cause == null) {
            cause = ft.getThrowable();
        }
        if (cause != null) {
            if (logger.isHideStacks()) {
                builder.append(": ").append(cause);
            } else {
                this.appendCause(builder, cause, "", Collections.newSetFromMap(new IdentityHashMap()));
            }
        }
    }

    private String renderedLevel(Level level) {
        return switch (level) {
            case Level.ERROR -> "ERROR";
            case Level.WARN -> "WARN ";
            case Level.INFO -> "INFO ";
            case Level.DEBUG -> "DEBUG";
            case Level.TRACE -> "TRACE";
            default -> "UNKNOWN";
        };
    }

    private void appendCause(StringBuilder builder, Throwable cause, String indent, Set<Throwable> visited) {
        builder.append(EOL).append(indent);
        if (visited.contains(cause)) {
            builder.append("[CIRCULAR REFERENCE: ");
            this.appendEscaped(builder, cause.toString());
            builder.append("]");
            return;
        }
        visited.add(cause);
        this.appendEscaped(builder, cause.toString());
        StackTraceElement[] elements = cause.getStackTrace();
        for (int i = 0; elements != null && i < elements.length; ++i) {
            builder.append(EOL).append(indent).append("\tat ");
            this.appendEscaped(builder, elements[i].toString());
        }
        for (Throwable suppressed : cause.getSuppressed()) {
            builder.append(EOL).append(indent).append("Suppressed: ");
            this.appendCause(builder, suppressed, "\t|" + indent, visited);
        }
        Throwable by = cause.getCause();
        if (by != null && by != cause) {
            builder.append(EOL).append(indent).append("Caused by: ");
            this.appendCause(builder, by, indent, visited);
        }
    }

    private void appendEscaped(StringBuilder builder, String str) {
        if (str == null) {
            return;
        }
        if (this.escapedMessages) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (Character.isISOControl(c)) {
                    if (c == '\n') {
                        builder.append('|');
                        continue;
                    }
                    if (c == '\r') {
                        builder.append('<');
                        continue;
                    }
                    builder.append('?');
                    continue;
                }
                builder.append(c);
            }
        } else {
            builder.append(str);
        }
    }
}

