/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet;

import jakarta.servlet.ReadListener;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;

public abstract class ServletInputStream
extends InputStream {
    protected ServletInputStream() {
    }

    public int read(ByteBuffer buffer) throws IOException {
        Objects.requireNonNull(buffer);
        if (!this.isReady()) {
            throw new IllegalStateException();
        }
        if (buffer.remaining() == 0) {
            return 0;
        }
        byte[] b = new byte[buffer.remaining()];
        int result = this.read(b);
        if (result == -1) {
            return -1;
        }
        int position = buffer.position();
        buffer.put(b, 0, result);
        buffer.position(position);
        buffer.limit(position + result);
        return result;
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        int c;
        if (len <= 0) {
            return 0;
        }
        int count = 0;
        while ((c = this.read()) != -1) {
            b[off++] = (byte)c;
            if (c != 10 && ++count != len) continue;
        }
        return count > 0 ? count : -1;
    }

    public abstract boolean isFinished();

    public abstract boolean isReady();

    public abstract void setReadListener(ReadListener var1);

    @Override
    public byte[] readAllBytes() throws IOException {
        return super.readAllBytes();
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        return super.readNBytes(len);
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        return super.readNBytes(b, off, len);
    }
}

