/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.EndOfLifeEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.InstanceRoleEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceMessageEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.LifelineNodeFigure;

public class SequenceMessagesRouter
extends AbstractRouter
implements ConnectionRouter {
    private static final PrecisionPoint BUTTON_DOWN_POINT = new PrecisionPoint();
    private static final PrecisionPoint A_POINT = new PrecisionPoint();
    private static final PrecisionPoint S_POINT = new PrecisionPoint();
    private static final PrecisionPoint F_POINT = new PrecisionPoint();
    private static Optional<Connection> dragInProgress = Optional.empty();
    private Map<Connection, Object> constraints = new WeakHashMap<Connection, Object>();

    public void setConstraint(Connection connection, Object constraint) {
        if (constraint instanceof BendpointRequest) {
            BendpointRequest br = (BendpointRequest)constraint;
            Object initialClick = br.getExtendedData().get("messageObliqueChangeBoundsRequestInitialClick");
            if (dragInProgress.isEmpty() && initialClick instanceof Point) {
                Point obliqueMsgInitialClick = (Point)initialClick;
                BUTTON_DOWN_POINT.setLocation(obliqueMsgInitialClick);
                dragInProgress = Optional.of(connection);
            }
            return;
        }
        this.constraints.put(connection, constraint);
    }

    public Object getConstraint(Connection connection) {
        return this.constraints.get(connection);
    }

    public void remove(Connection connection) {
        this.constraints.remove(connection);
    }

    public void route(Connection conn) {
        if (!this.isValidConnection(conn)) {
            return;
        }
        IGraphicalEditPart part = null;
        if (conn instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure) {
            part = ((AbstractDiagramEdgeEditPart.ViewEdgeFigure)conn).getEditPart();
        }
        boolean isObliqueMessage = this.isObliqueMessage(part);
        boolean isReflexiveMessage = this.isReflectiveMessage(part);
        List<Bendpoint> bendpoints = this.getRefreshedConstraint(conn, isReflexiveMessage, isObliqueMessage);
        Point sourceRef = this.getReferencePoint(conn, true, bendpoints);
        Point targetRef = this.getReferencePoint(conn, false, bendpoints);
        boolean leftToRight = conn.getSourceAnchor().getReferencePoint().x < conn.getTargetAnchor().getReferencePoint().x;
        boolean msgToSelf = sourceRef.x == targetRef.x && sourceRef.y != targetRef.y || bendpoints.size() >= 4;
        msgToSelf = msgToSelf || isReflexiveMessage;
        msgToSelf = msgToSelf && (!isObliqueMessage || isReflexiveMessage);
        Rectangle sourceOwnerBounds = this.getAnchorOwnerBounds(conn.getSourceAnchor());
        Rectangle targetOwnerBounds = this.getAnchorOwnerBounds(conn.getTargetAnchor());
        sourceRef.setX(this.getRefX(true, leftToRight, msgToSelf, sourceOwnerBounds, conn.getSourceAnchor().getOwner()));
        targetRef.setX(this.getRefX(false, leftToRight, msgToSelf, targetOwnerBounds, conn.getTargetAnchor().getOwner()));
        PointList points = new PointList(Math.max(2, bendpoints.size()));
        if (msgToSelf) {
            Point secondPoint = sourceRef.getCopy();
            Point thirdPoint = targetRef.getCopy();
            double zoom = part == null ? 1.0 : GraphicalHelper.getZoom((EditPart)part);
            int hGap = SequenceMessagesRouter.getMessageFromPart(part).filter(msg -> isReflexiveMessage).map(Message::getReflexiveMessageWidth).orElse(30);
            secondPoint.setX(Math.max(sourceRef.x, targetRef.x) + (int)((double)hGap * zoom));
            thirdPoint.setX(secondPoint.x);
            conn.translateToRelative((Translatable)sourceRef);
            conn.translateToRelative((Translatable)secondPoint);
            conn.translateToRelative((Translatable)thirdPoint);
            points.addPoint(sourceRef);
            points.addPoint(secondPoint);
            points.addPoint(thirdPoint);
        } else {
            conn.translateToRelative((Translatable)sourceRef);
            points.addPoint(sourceRef);
        }
        conn.translateToRelative((Translatable)targetRef);
        points.addPoint(targetRef);
        conn.setPoints(points);
    }

    private int getRefX(boolean source, boolean leftToRight, boolean msgToSelf, Rectangle anchorOwnerBounds, IFigure anchorOwner) {
        int refX;
        boolean onLeft = source && !leftToRight || leftToRight && !source;
        boolean bl = onLeft = onLeft && !msgToSelf;
        if (msgToSelf) {
            refX = anchorOwnerBounds.getRight().x;
        } else {
            int n = refX = onLeft ? anchorOwnerBounds.getLeft().x : anchorOwnerBounds.getRight().x;
        }
        if (anchorOwner instanceof LifelineNodeFigure) {
            LifelineNodeFigure lnf = (LifelineNodeFigure)anchorOwner;
            int refMidWidth = (anchorOwnerBounds.width - lnf.getLineWidth()) / 2;
            refX += onLeft ? refMidWidth : -refMidWidth;
        }
        return refX;
    }

    private Point getReferencePoint(Connection conn, boolean source, List<Bendpoint> bendpoints) {
        Point ref;
        if (bendpoints.isEmpty()) {
            ConnectionAnchor anchor = source ? conn.getSourceAnchor() : conn.getTargetAnchor();
            ref = anchor.getReferencePoint().getCopy();
        } else {
            int index = source ? 0 : bendpoints.size() - 1;
            ref = new Point(bendpoints.get(index).getLocation());
            conn.translateToAbsolute((Translatable)ref);
        }
        return ref;
    }

    private Rectangle getAnchorOwnerBounds(ConnectionAnchor anchor) {
        Rectangle ownerBounds = anchor.getOwner().getBounds().getCopy();
        anchor.getOwner().getParent().translateToAbsolute((Translatable)ownerBounds);
        return ownerBounds;
    }

    private static Optional<Message> getMessageFromPart(IGraphicalEditPart part) {
        SequenceMessageEditPart isePart;
        ISequenceEvent iSequenceEvent;
        Optional<Message> optMsg = Optional.empty();
        if (part instanceof SequenceMessageEditPart && (iSequenceEvent = (isePart = (SequenceMessageEditPart)part).getISequenceEvent()) instanceof Message) {
            Message msg = (Message)iSequenceEvent;
            return Optional.of(msg);
        }
        return optMsg;
    }

    private boolean isObliqueMessage(IGraphicalEditPart part) {
        return SequenceMessagesRouter.getMessageFromPart(part).map(Message::isOblique).orElse(false);
    }

    private boolean isReflectiveMessage(IGraphicalEditPart part) {
        return SequenceMessagesRouter.getMessageFromPart(part).map(Message::isReflective).orElse(false);
    }

    private List<Bendpoint> getRefreshedConstraint(Connection conn, boolean isReflectiveMessage, boolean isObliqueMessage) {
        boolean noBendpointsAtbeginning = false;
        List<Bendpoint> bendpoints = (List<Bendpoint>)this.getConstraint(conn);
        if (bendpoints == null) {
            noBendpointsAtbeginning = true;
            bendpoints = Collections.emptyList();
        }
        this.refreshBendpoints(bendpoints, conn, isReflectiveMessage, isObliqueMessage);
        if (!noBendpointsAtbeginning || !Collections.emptyList().equals(bendpoints)) {
            this.setConstraint(conn, bendpoints);
        }
        return bendpoints;
    }

    private boolean isValidConnection(Connection conn) {
        return this.isValidAnchor(conn.getSourceAnchor()) && this.isValidAnchor(conn.getTargetAnchor());
    }

    private boolean isValidAnchor(ConnectionAnchor anchor) {
        return anchor != null && anchor.getOwner() != null;
    }

    private void refreshBendpoints(List<Bendpoint> bendpoints, Connection conn, boolean isReflexiveMessage, boolean isObliqueMessage) {
        IGraphicalEditPart part = null;
        if (conn instanceof AbstractDiagramEdgeEditPart.ViewEdgeFigure) {
            part = ((AbstractDiagramEdgeEditPart.ViewEdgeFigure)conn).getEditPart();
        }
        if (bendpoints.size() > 2) {
            if (isReflexiveMessage) {
                if (bendpoints.size() > 4) {
                    this.align5BendpointsOfMessageToSelf(bendpoints, conn);
                } else if (bendpoints.size() == 4) {
                    this.align4BendpointsOfMessageToSelf(bendpoints, conn);
                }
            } else if (isObliqueMessage) {
                this.refreshBendpointsForObliqueMessage(bendpoints, conn);
            } else {
                Bendpoint start = bendpoints.get(0);
                Bendpoint end = bendpoints.get(bendpoints.size() - 1);
                Bendpoint moveRef = bendpoints.get(1);
                bendpoints.clear();
                A_POINT.setLocation(start.getLocation());
                A_POINT.setY(moveRef.getLocation().y);
                AbsoluteBendpoint newStart = new AbsoluteBendpoint((Point)A_POINT);
                bendpoints.add((Bendpoint)newStart);
                bendpoints.add(moveRef);
                A_POINT.setLocation(end.getLocation());
                A_POINT.setY(moveRef.getLocation().y);
                AbsoluteBendpoint newEnd = new AbsoluteBendpoint((Point)A_POINT);
                bendpoints.add((Bendpoint)newEnd);
            }
        } else if (bendpoints.size() == 2) {
            if (dragInProgress.isPresent() && (dragInProgress.get() == conn || dragInProgress.get().getParent() == null)) {
                A_POINT.setLocation(0, 0);
                S_POINT.setLocation(0, 0);
                F_POINT.setLocation(0, 0);
                dragInProgress = Optional.empty();
            }
            Bendpoint start = bendpoints.get(0);
            Bendpoint end = bendpoints.get(bendpoints.size() - 1);
            bendpoints.clear();
            AbsoluteBendpoint newStart = new AbsoluteBendpoint(start.getLocation());
            AbsoluteBendpoint newEnd = new AbsoluteBendpoint(end.getLocation());
            if (isReflexiveMessage) {
                bendpoints.addAll(this.createMessageToSelf(start, end, (SequenceMessageEditPart)part));
            } else {
                if (part instanceof SequenceMessageEditPart && (((SequenceMessageEditPart)part).getTarget() instanceof InstanceRoleEditPart || ((SequenceMessageEditPart)part).getTarget() instanceof EndOfLifeEditPart)) {
                    IGraphicalEditPart target = (IGraphicalEditPart)((SequenceMessageEditPart)part).getTarget();
                    Rectangle targetBounds = target.getFigure().getBounds();
                    int yCenterPosition = targetBounds.y + targetBounds.height / 2;
                    newStart.getLocation().setY(yCenterPosition);
                }
                bendpoints.add((Bendpoint)newStart);
                if (!isObliqueMessage) {
                    newEnd.getLocation().setY(newStart.getLocation().y);
                }
                bendpoints.add((Bendpoint)newEnd);
            }
        }
    }

    private void refreshBendpointsForObliqueMessage(List<Bendpoint> bendpoints, Connection conn) {
        Bendpoint start = bendpoints.get(0);
        Bendpoint cursorReference = bendpoints.get(1);
        Bendpoint finish = bendpoints.get(bendpoints.size() - 1);
        if (SequenceMessagesRouter.BUTTON_DOWN_POINT.y != 0 && dragInProgress.isPresent() && dragInProgress.get() == conn) {
            A_POINT.setLocation((Point)BUTTON_DOWN_POINT);
            BUTTON_DOWN_POINT.setLocation(0, 0);
            S_POINT.setLocation(start.getLocation());
            F_POINT.setLocation(finish.getLocation());
        }
        Bendpoint newStart = start;
        Bendpoint newFinish = finish;
        int deltaY = cursorReference.getLocation().y - SequenceMessagesRouter.A_POINT.y;
        int width = finish.getLocation().x - start.getLocation().x;
        if (width < 0) {
            if (SequenceMessagesRouter.A_POINT.x == 1) {
                Point preciseFinish = new Point(finish.getLocation().x, Math.max(SequenceMessagesRouter.S_POINT.y + 5, SequenceMessagesRouter.F_POINT.y + deltaY));
                newFinish = new AbsoluteBendpoint(preciseFinish);
            } else if (SequenceMessagesRouter.A_POINT.x == -1) {
                Point preciseStart = new Point(start.getLocation().x, Math.min(SequenceMessagesRouter.F_POINT.y - 5, SequenceMessagesRouter.S_POINT.y + deltaY));
                newStart = new AbsoluteBendpoint(preciseStart);
            } else {
                Point preciseStart = new Point(start.getLocation().x, SequenceMessagesRouter.S_POINT.y + deltaY);
                newStart = new AbsoluteBendpoint(preciseStart);
                Point preciseFinish = new Point(finish.getLocation().x, SequenceMessagesRouter.F_POINT.y + deltaY);
                newFinish = new AbsoluteBendpoint(preciseFinish);
            }
        } else if (SequenceMessagesRouter.A_POINT.x == -1) {
            Point preciseStart = new Point(start.getLocation().x, Math.min(SequenceMessagesRouter.F_POINT.y - 5, SequenceMessagesRouter.S_POINT.y + deltaY));
            newStart = new AbsoluteBendpoint(preciseStart);
        } else if (SequenceMessagesRouter.A_POINT.x == 1) {
            Point preciseFinish = new Point(finish.getLocation().x, Math.max(SequenceMessagesRouter.S_POINT.y + 5, SequenceMessagesRouter.F_POINT.y + deltaY));
            newFinish = new AbsoluteBendpoint(preciseFinish);
        } else {
            Point preciseStart = new Point(start.getLocation().x, SequenceMessagesRouter.S_POINT.y + deltaY);
            newStart = new AbsoluteBendpoint(preciseStart);
            Point preciseFinish = new Point(finish.getLocation().x, SequenceMessagesRouter.F_POINT.y + deltaY);
            newFinish = new AbsoluteBendpoint(preciseFinish);
        }
        bendpoints.clear();
        bendpoints.add(newStart);
        bendpoints.add(cursorReference);
        bendpoints.add(newFinish);
    }

    private void align4BendpointsOfMessageToSelf(List<Bendpoint> bendpoints, Connection conn) {
        AbsoluteBendpoint oldThirdPoint;
        AbsoluteBendpoint oldSecondPoint;
        AbsoluteBendpoint newStart = new AbsoluteBendpoint(bendpoints.get(0).getLocation());
        AbsoluteBendpoint newSecondPoint = new AbsoluteBendpoint(bendpoints.get(1).getLocation());
        AbsoluteBendpoint newThirdPoint = new AbsoluteBendpoint(bendpoints.get(2).getLocation());
        AbsoluteBendpoint newEnd = new AbsoluteBendpoint(bendpoints.get(3).getLocation());
        bendpoints.clear();
        if (conn.getPoints() != null && conn.getPoints().size() == 4) {
            oldSecondPoint = new AbsoluteBendpoint(conn.getPoints().getPoint(1));
            oldThirdPoint = new AbsoluteBendpoint(conn.getPoints().getPoint(2));
        } else {
            oldSecondPoint = newSecondPoint;
            oldThirdPoint = newThirdPoint;
        }
        if (oldSecondPoint.getLocation().y != newSecondPoint.getLocation().y) {
            if (newSecondPoint.getLocation().y > newThirdPoint.getLocation().y - 10) {
                newSecondPoint.getLocation().setY(newThirdPoint.getLocation().y - 10);
            }
            newStart.getLocation().setY(newSecondPoint.getLocation().y);
        }
        if (oldThirdPoint.getLocation().y != newThirdPoint.getLocation().y) {
            if (newThirdPoint.getLocation().y < newSecondPoint.getLocation().y + 10) {
                newThirdPoint.getLocation().setY(newSecondPoint.getLocation().y + 10);
            }
            newEnd.getLocation().setY(newThirdPoint.getLocation().y);
        }
        bendpoints.add((Bendpoint)newStart);
        bendpoints.add((Bendpoint)newSecondPoint);
        bendpoints.add((Bendpoint)newThirdPoint);
        bendpoints.add((Bendpoint)newEnd);
    }

    private void align5BendpointsOfMessageToSelf(List<Bendpoint> bendpoints, Connection conn) {
        AbsoluteBendpoint newStart = new AbsoluteBendpoint(bendpoints.get(0).getLocation());
        AbsoluteBendpoint secondPoint = new AbsoluteBendpoint(bendpoints.get(1).getLocation());
        AbsoluteBendpoint thirdPoint = new AbsoluteBendpoint(bendpoints.get(2).getLocation());
        AbsoluteBendpoint fourthPoint = new AbsoluteBendpoint(bendpoints.get(3).getLocation());
        AbsoluteBendpoint newEnd = new AbsoluteBendpoint(bendpoints.get(4).getLocation());
        bendpoints.clear();
        AbsoluteBendpoint oldSecondPoint = new AbsoluteBendpoint(conn.getPoints().getPoint(1));
        AbsoluteBendpoint oldThirdPoint = new AbsoluteBendpoint(conn.getPoints().getPoint(2));
        if (oldSecondPoint.getLocation().y != secondPoint.getLocation().y) {
            if (secondPoint.getLocation().y > oldThirdPoint.getLocation().y - 10) {
                secondPoint.getLocation().setY(oldThirdPoint.getLocation().y - 10);
            }
            newStart.getLocation().setY(secondPoint.getLocation().y);
            thirdPoint.getLocation().setY(secondPoint.getLocation().y);
        } else if (oldThirdPoint.getLocation().y != fourthPoint.getLocation().y) {
            if (fourthPoint.getLocation().y < oldSecondPoint.getLocation().y + 10) {
                fourthPoint.getLocation().setY(oldSecondPoint.getLocation().y + 10);
            }
            thirdPoint.getLocation().setY(fourthPoint.getLocation().y);
            newEnd.getLocation().setY(fourthPoint.getLocation().y);
        }
        bendpoints.add((Bendpoint)newStart);
        bendpoints.add((Bendpoint)secondPoint);
        bendpoints.add((Bendpoint)thirdPoint);
        bendpoints.add((Bendpoint)fourthPoint);
        bendpoints.add((Bendpoint)newEnd);
    }

    private List<Bendpoint> createMessageToSelf(Bendpoint start, Bendpoint end, SequenceMessageEditPart part) {
        ArrayList<Bendpoint> messageToSelfBendpoint = new ArrayList<Bendpoint>();
        AbsoluteBendpoint newStart = new AbsoluteBendpoint(start.getLocation());
        AbsoluteBendpoint newSecondPoint = new AbsoluteBendpoint(start.getLocation());
        AbsoluteBendpoint newThirdPoint = new AbsoluteBendpoint(end.getLocation());
        AbsoluteBendpoint newEnd = new AbsoluteBendpoint(end.getLocation());
        int minGap = 10;
        if (newEnd.getLocation().y - newStart.getLocation().y < minGap) {
            newThirdPoint.getLocation().setY(newStart.getLocation().y + minGap);
            newEnd.getLocation().setY(newThirdPoint.getLocation().y);
        }
        messageToSelfBendpoint.add((Bendpoint)newStart);
        messageToSelfBendpoint.add((Bendpoint)newSecondPoint);
        messageToSelfBendpoint.add((Bendpoint)newThirdPoint);
        messageToSelfBendpoint.add((Bendpoint)newEnd);
        return messageToSelfBendpoint;
    }
}

