/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editors.ie.events.impl;

import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.Variant;

public abstract class AbstractEventParameters {
    protected OleEvent event;

    protected AbstractEventParameters(OleEvent event) {
        this.event = event;
    }

    protected Variant getVariant(int index) {
        try {
            return this.event.arguments[index];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String getString(int index) {
        try {
            return this.event.arguments[index].getString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected int getInteger(int index) {
        try {
            return this.event.arguments[index].getInt();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    protected boolean getBoolean(int index) {
        try {
            return this.event.arguments[index].getBoolean();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void setBooleanByRef(int index, boolean value) {
        try {
            this.event.arguments[index].setByRef(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int getIntegerByRef(int index) {
        try {
            int byRef = this.event.arguments[index].getByRef();
            if (byRef != 0) {
                int[] pValue = new int[1];
                MemoryUtil.MoveMemory((int[])pValue, (int)byRef, (int)4);
                return pValue[0];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    protected void setIntegerByRef(int index, int value) {
        try {
            this.event.arguments[index].setByRef(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int getDispatchAddress(int index) {
        try {
            return this.event.arguments[index].getDispatch().getAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    protected int getControlSiteAddress() {
        if (this.event.widget instanceof OleControlSite) {
            Variant varWebSite = new Variant(new OleAutomation((OleClientSite)((OleControlSite)this.event.widget)));
            try {
                int n = varWebSite.getDispatch().getAddress();
                return n;
            }
            finally {
                varWebSite.dispose();
            }
        }
        return 0;
    }
}

