/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.util.Comparator;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedSizeQueue {
    private Object[] fQueue;
    private int fSize;
    private int fNextIndex = 0;
    private int fMinIndex = 0;

    public FixedSizeQueue(int queueSize) {
        this.fQueue = new Object[queueSize];
        this.fSize = queueSize;
    }

    public int getQueueSize() {
        return this.fSize;
    }

    public synchronized void clear() {
        if (this.fMinIndex != this.fNextIndex) {
            do {
                this.fQueue[this.fMinIndex++] = null;
                if (this.fMinIndex <= this.fSize) continue;
                this.fMinIndex = 0;
            } while (this.fMinIndex != this.fNextIndex);
        }
        this.fNextIndex = 0;
        this.fMinIndex = 0;
        this.fQueue[0] = null;
    }

    public synchronized boolean isEmpty() {
        return this.fNextIndex == this.fMinIndex;
    }

    public synchronized int getSize() {
        int d = this.fNextIndex - this.fMinIndex;
        return d >= 0 ? d : d + this.fSize;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void put(Object obj) throws InterruptedException {
        if (obj != null) ** GOTO lbl4
        throw new IllegalArgumentException("null");
lbl-1000:
        // 1 sources

        {
            this.wait();
lbl4:
            // 2 sources

            ** while (this.fQueue[this.fNextIndex] != null)
        }
lbl5:
        // 1 sources

        this.fQueue[this.fNextIndex++] = obj;
        if (this.fNextIndex >= this.fSize) {
            this.fNextIndex = 0;
        }
        this.notifyAll();
    }

    public synchronized void put(Object obj, long timeout) throws TimeoutException, InterruptedException {
        if (timeout == 0L) {
            this.put(obj);
        } else {
            if (obj == null) {
                throw new IllegalArgumentException("null");
            }
            if (this.fQueue[this.fNextIndex] != null) {
                long elapsed;
                long t0 = System.currentTimeMillis();
                long wait = timeout;
                boolean timedout = true;
                do {
                    this.wait(wait);
                    if (this.fQueue[this.fNextIndex] != null) continue;
                    timedout = false;
                    break;
                } while ((wait = timeout - (elapsed = System.currentTimeMillis() - t0)) > 0L);
                if (timedout) {
                    throw new TimeoutException("FixedSizeQueue.put");
                }
            }
            this.fQueue[this.fNextIndex++] = obj;
            if (this.fNextIndex >= this.fSize) {
                this.fNextIndex = 0;
            }
            this.notifyAll();
        }
    }

    public synchronized Object remove() throws InterruptedException {
        Object req;
        while ((req = this.fQueue[this.fMinIndex]) == null) {
            this.wait();
        }
        this.fQueue[this.fMinIndex++] = null;
        if (this.fMinIndex >= this.fSize) {
            this.fMinIndex = 0;
        }
        this.notifyAll();
        return req;
    }

    public synchronized Object remove(long timeout) throws TimeoutException, InterruptedException {
        Object req = this.fQueue[this.fMinIndex];
        if (req == null) {
            long elapsed;
            long t0 = System.currentTimeMillis();
            long wait = timeout;
            do {
                this.wait(wait);
            } while ((req = this.fQueue[this.fMinIndex]) == null && (wait = timeout - (elapsed = System.currentTimeMillis() - t0)) > 0L);
            if (req == null) {
                throw new TimeoutException("FixedSizeQueue.remove");
            }
        }
        this.fQueue[this.fMinIndex++] = null;
        if (this.fMinIndex >= this.fSize) {
            this.fMinIndex = 0;
        }
        this.notifyAll();
        return req;
    }

    public synchronized Object nonBlockingRemove() {
        Object req = this.fQueue[this.fMinIndex];
        if (req != null) {
            this.fQueue[this.fMinIndex++] = null;
            if (this.fMinIndex >= this.fSize) {
                this.fMinIndex = 0;
            }
            this.notifyAll();
        }
        return req;
    }

    public synchronized Object matchAndRemove(Object o, Comparator<Object> comparator) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        Object req = this.fQueue[this.fMinIndex];
        if (req == null) {
            return null;
        }
        if (comparator.compare(o, req) == 0) {
            this.fQueue[this.fMinIndex++] = null;
            if (this.fMinIndex >= this.fSize) {
                this.fMinIndex = 0;
            }
            this.notifyAll();
            return req;
        }
        return null;
    }
}

