/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponsePushbackMessage;
import org.eclipse.actf.util.httpproxy.core.IMessageBody;
import org.eclipse.actf.util.httpproxy.core.IPushbackMessageBody;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.internal.httpproxy.core.ChunkedMessageBodyReader;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseInMemoryMessage;
import org.eclipse.actf.util.internal.httpproxy.core.PushbackMessageBody;

public class HTTPResponsePushbackMessage
extends HTTPResponseInMemoryMessage
implements IHTTPResponsePushbackMessage {
    public HTTPResponsePushbackMessage(long serial, byte[] version, byte[] statusCode, byte[] reasonPhrase, IMessageBody body, int pushbackBufferSize) {
        super(serial, version, statusCode, reasonPhrase);
        if (body != null) {
            InputStream is = body.getMessageBodyTimeoutInputStream();
            PushbackMessageBody msgBody = body.isChunkedEncoding() ? new PushbackMessageBody(is, pushbackBufferSize) : new PushbackMessageBody(is, pushbackBufferSize, body.getContentLength());
            super.setOriginalMessageBody(msgBody);
        }
    }

    public byte[] readBody(long timeout, boolean pushback) throws IOException, TimeoutException {
        PushbackMessageBody msgBody = (PushbackMessageBody)this.getMessageBody();
        if (msgBody == null) {
            return null;
        }
        InputStream body = msgBody.getMessageBodyInputStream();
        int contentLength = msgBody.getContentLength();
        if (body == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (contentLength >= 0) {
            int i = 0;
            while (i < contentLength) {
                os.write(body.read());
                ++i;
            }
        } else {
            ChunkedMessageBodyReader chunkReader = new ChunkedMessageBodyReader(body);
            chunkReader.readChunkedMessage(timeout, os, this);
        }
        byte[] outBytes = os.toByteArray();
        if (pushback) {
            PushbackInputStream is = msgBody.getMessageBodyPushBackInputStream();
            is.unread(outBytes);
        }
        return outBytes;
    }

    public HTTPResponsePushbackMessage(IHTTPResponseMessage base, int pushbackBufferSize) {
        this(base.getSerial(), base.getHTTPVersionAsBytes(), base.getStatusCodeAsBytes(), base.getReasonPhraseAsBytes(), base.getMessageBody(), pushbackBufferSize);
        this.setBaseHeaders(base);
    }

    public IPushbackMessageBody getPushbackMessageBody() {
        return (PushbackMessageBody)this.getMessageBody();
    }
}

