/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import org.eclipse.actf.util.httpproxy.core.IClientConnection;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMalformedResponseMessage;

public class Session {
    static final Logger LOGGER = Logger.getLogger(Session.class);
    private IHTTPRequestMessage fRequestMsg = null;
    private IHTTPResponseMessage fResponseMsg = null;

    public synchronized IHTTPRequestMessage getRequestMessage() {
        return this.fRequestMsg;
    }

    public synchronized void start(IHTTPRequestMessage req) throws InterruptedException {
        if (req == this.fRequestMsg) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("A session started: stat=" + this.fRequestMsg + ", req=" + req);
        }
        while (this.fRequestMsg != null) {
            this.wait();
        }
        this.fRequestMsg = req;
        this.notifyAll();
    }

    public synchronized void start(IHTTPRequestMessage req, long timeout) throws InterruptedException, TimeoutException {
        if (req == this.fRequestMsg) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("A session started: stat=" + this.fRequestMsg + ", req=" + req);
        }
        if (this.fRequestMsg != null) {
            long deadLine = System.currentTimeMillis() + timeout;
            long wait = timeout;
            while (wait > 0L) {
                this.wait(wait);
                if (this.fResponseMsg == null) break;
                wait = deadLine - System.currentTimeMillis();
            }
            if (this.fRequestMsg == null) {
                throw new TimeoutException("Session.start");
            }
        }
        this.fRequestMsg = req;
        this.notifyAll();
    }

    /*
     * Unable to fully structure code
     */
    public synchronized boolean receiveResponse(IHTTPResponseMessage response) throws InterruptedException {
        if (this.fRequestMsg == null || this.fRequestMsg.getSerial() == response.getSerial()) ** GOTO lbl4
        return false;
lbl-1000:
        // 1 sources

        {
            this.wait();
lbl4:
            // 2 sources

            ** while (this.fResponseMsg != null)
        }
lbl5:
        // 1 sources

        this.fResponseMsg = response;
        this.notifyAll();
        return true;
    }

    protected synchronized IHTTPResponseMessage waitResponse(long timeout) throws InterruptedException, TimeoutException {
        if (this.fResponseMsg == null) {
            long deadLine = System.currentTimeMillis() + timeout;
            long wait = timeout;
            while (wait > 0L) {
                this.wait(wait);
                if (this.fResponseMsg != null) break;
                wait = deadLine - System.currentTimeMillis();
            }
            if (this.fResponseMsg == null) {
                throw new TimeoutException("ResponseSync.get");
            }
        }
        IHTTPResponseMessage response = this.fResponseMsg;
        this.fResponseMsg = null;
        return response;
    }

    protected synchronized void notifyCompletion() {
        this.fRequestMsg = null;
        this.notifyAll();
    }

    public synchronized IHTTPResponseMessage getAndSendResponse(IClientConnection client, long timeout) throws InterruptedException, TimeoutException, IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getAndSendResponse: entrered");
        }
        long t0 = System.currentTimeMillis();
        IHTTPResponseMessage response = this.waitResponse(timeout);
        if (response instanceof HTTPMalformedResponseMessage) {
            throw ((HTTPMalformedResponseMessage)response).getIOException();
        }
        long t1 = System.currentTimeMillis();
        if ((timeout -= t1 - t0) <= 0L) {
            timeout = 1L;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getAndSendResponse: got a response");
        }
        try {
            client.sendResponse(timeout, response);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("getAndSendResponse: sent a response");
            }
        }
        catch (IOException iOException) {
            return response;
        }
        catch (TimeoutException timeoutException) {
            return response;
        }
        this.notifyCompletion();
        return null;
    }

    public synchronized IHTTPResponseMessage getResponse(long timeout) throws InterruptedException, TimeoutException, IOException {
        IHTTPResponseMessage response = this.waitResponse(timeout);
        this.notifyCompletion();
        if (response instanceof HTTPMalformedResponseMessage) {
            throw ((HTTPMalformedResponseMessage)response).getIOException();
        }
        return response;
    }
}

