/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.proxy;

import java.io.IOException;
import java.net.Socket;
import org.eclipse.actf.util.httpproxy.ExternalProxyConfig;
import org.eclipse.actf.util.httpproxy.proxy.IClientStateManager;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPProxyConnection;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPProxyTranscoderFactory;
import org.eclipse.actf.util.httpproxy.proxy.ISecretManager;
import org.eclipse.actf.util.internal.httpproxy.HTTPProxy;
import org.eclipse.actf.util.internal.httpproxy.core.ClientConnection;
import org.eclipse.actf.util.internal.httpproxy.core.ServerConnection;
import org.eclipse.actf.util.internal.httpproxy.proxy.HTTPRequestDispatcher;

public class HTTPProxyConnection
extends ClientConnection
implements IHTTPProxyConnection {
    private final HTTPProxy fProxy;
    private final int timeout;

    HTTPProxy getProxy() {
        return this.fProxy;
    }

    public ISecretManager getSecretManager() {
        return this.fProxy.getSecretManager();
    }

    ExternalProxyConfig getExternalProxyConfig() {
        return this.fProxy.getExternalProxyConfig();
    }

    public int getListenPort() {
        return this.fProxy.getListenPort();
    }

    void notifySuccessfulServerConnection(ServerConnection conn) {
    }

    public void init(IClientStateManager clientStateManager, Socket clientSock, long keepAlive, int initServerGroupIdx) throws IOException {
        this.setConnectionName("[id:" + clientSock.getPort() + "] HTTPProxyConnection");
        HTTPRequestDispatcher dispatcher = new HTTPRequestDispatcher(this, clientStateManager, clientSock, this.getQueueSize(), this.timeout);
        IHTTPProxyTranscoderFactory factory = this.fProxy.getProxyTranscoderFactory();
        if (factory != null) {
            dispatcher.setTranscoder(factory.newInstance(dispatcher.getDispatcherId()));
        }
        this.initInternal(clientSock, keepAlive, this.timeout, dispatcher);
    }

    public HTTPProxyConnection(HTTPProxy fProxy, int queueSize, int timeout) {
        super(fProxy, queueSize);
        this.fProxy = fProxy;
        this.timeout = timeout;
    }
}

