/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.html.errorhandler;

import java.io.IOException;
import org.eclipse.actf.model.dom.html.IErrorHandler;
import org.eclipse.actf.model.dom.html.IParser;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UnknownElementErrorHandler
implements IErrorHandler {
    private String[] unknownElements;
    private String publicID;

    public UnknownElementErrorHandler(String unknownElement, String publicID) {
        this.unknownElements = new String[1];
        this.unknownElements[0] = unknownElement;
        this.publicID = publicID;
    }

    public UnknownElementErrorHandler(String[] unknownElements, String publicID) {
        this.unknownElements = unknownElements;
        this.publicID = publicID;
    }

    public boolean handleError(int code, IParser parser, Node errorNode) throws ParseException, IOException {
        if (code == 8 && errorNode instanceof Element) {
            int i = 0;
            while (i < this.unknownElements.length) {
                if (errorNode.getNodeName().equalsIgnoreCase(this.unknownElements[i])) {
                    parser.error(8, ((ISGMLParser)parser).getDTD() + " does not define FRAMESET. " + " Try to change DTD to " + this.publicID);
                    ((ISGMLParser)parser).setupDTD(this.publicID);
                    parser.pushBackNode(errorNode);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

