/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.modelgroup;

import java.util.Hashtable;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLParser;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.CompositeModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.IModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.PlusModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.RepModelGroup;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SeqModelGroup
extends CompositeModelGroup {
    public SeqModelGroup(IModelGroup modelGroup) {
        super(modelGroup);
    }

    public void add(IModelGroup modelGroup) {
        if (modelGroup instanceof SeqModelGroup) {
            SeqModelGroup another = (SeqModelGroup)modelGroup;
            int i = 0;
            while (i < another.childLength) {
                another.children[i].refer(false);
                this.children[this.childLength++] = another.children[i];
                ++i;
            }
        } else {
            this.children[this.childLength++] = modelGroup;
            modelGroup.refer(false);
        }
    }

    public String toString() {
        String ret = new String("(");
        int i = 0;
        while (i < this.childLength - 1) {
            ret = String.valueOf(ret) + this.children[i] + ',';
            ++i;
        }
        ret = String.valueOf(ret) + this.children[this.childLength - 1] + ')';
        return ret;
    }

    public boolean match(ISGMLParser parser, Node parent, Node child) {
        Hashtable<Node, Integer> map = parser.getSeqMap();
        Integer current = map.get(parent);
        int index = current == null ? 0 : current;
        int rest = 0;
        IModelGroup[] skipped = parser.getSeqArray();
        int skippedNum = 0;
        while (index < this.childLength) {
            IModelGroup mg = this.children[index];
            if (mg.match(parser, parent, child)) {
                if (!(mg instanceof PlusModelGroup) && !(mg instanceof RepModelGroup)) {
                    ++index;
                }
                if (skippedNum > 0) {
                    parser.error(7, "Order of " + parent + "'s children is wrong.");
                }
                map.put(parent, new Integer(index));
                return true;
            }
            if (mg.optional()) {
                ++index;
                continue;
            }
            if (rest < 2) {
                skipped[skippedNum++] = mg;
                ++rest;
                ++index;
                continue;
            }
            System.out.println("match: false");
            return false;
        }
        Node sibling = parent.getLastChild();
        if (sibling instanceof Element && child instanceof Element && sibling.getNodeName().equalsIgnoreCase(child.getNodeName()) && parser.autoGenerated((Element)sibling)) {
            while (sibling.hasChildNodes()) {
                Node sibChild = sibling.getFirstChild();
                sibling.removeChild(sibChild);
                child.appendChild(sibChild);
            }
            parent.replaceChild(child, sibling);
            return true;
        }
        return false;
    }

    public boolean optional() {
        int i = this.childLength - 1;
        while (i >= 0) {
            if (!this.children[i].optional()) {
                return false;
            }
            --i;
        }
        return true;
    }
}

