/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.scripteditor.reader;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.actf.ai.internal.ui.scripteditor.EditPanelTab;
import org.eclipse.actf.ai.internal.ui.scripteditor.VolumeLevelCanvas;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXReader
extends DefaultHandler {
    private SAXParserFactory spf;
    private SAXParser sp;
    private EditPanelTab instParent;
    private static final String XML_TAG_URI = "targetSite";
    private static final String XML_ATTR_URI = "uri";
    private static final String XML_TAG_ITEM = "item";
    private static final String XML_TAG_START = "start";
    private static final String XML_TAG_DURATION = "duration";
    private static final String XML_TAG_DESC = "description";
    private static final String XML_ATTR_SPEED = "speed";
    private static final String XML_ATTR_GENDER = "gender";
    private static final String XML_ATTR_EXTENDED = "extended";
    private static final String XML_ATTR_LANG = "xml:lang";
    private static final String XML_TAG_WAVE = "wave";
    private static final String XML_ATTR_LOCAL = "local";
    private static final String XML_ATTR_DURATION = "duration";
    private static final String XML_ATTR_ENABLED = "enabled";
    private static final String XML_TAG_VOLLVL = "volumeLevel";
    private static final String URI_BLANK = "about:blank";
    private String bkup_uri = "about:blank";
    private String bkup_start = "00:00:000";
    private String bkup_duration = "00:00:000";
    private String bkup_desc = "";
    private String bkup_extended = "false";
    private String bkup_speed = "50";
    private String bkup_gender = "male";
    private String bkup_lang = "en";
    private String bkup_vollvl_loc = "";
    private boolean statWavTag = false;
    private boolean bkup_wav_ena = false;
    private String bkup_wav_uri = "about:blank";
    private String bkup_wav_loc = null;
    private String bkup_wav_duration = "00:00:000";
    private String bkup_wav_speed = "100";
    private static final int SAX_STAT_IDLE = 0;
    private static final int SAX_STAT_URI = 1;
    private static final int SAX_STAT_SITEM = 2;
    private static final int SAX_STAT_START = 3;
    private static final int SAX_STAT_DURATION = 4;
    private static final int SAX_STAT_DESC = 5;
    private static final int SAX_STAT_WAVE = 6;
    private static final int SAX_STAT_EITEM = 7;
    private static final int SAX_STAT_VOLLVL = 8;
    private int currentStatus = 0;
    private int currentChildStatus = 0;

    public void startSAXReader(String fname, EditPanelTab parent) throws SAXException, ParserConfigurationException {
        try {
            this.instParent = parent;
            this.spf = SAXParserFactory.newInstance();
            this.sp = this.spf.newSAXParser();
            this.sp.parse(new File(fname), (DefaultHandler)this);
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {}
    }

    public String getUri() {
        if (this.bkup_uri == null) {
            this.bkup_uri = URI_BLANK;
        }
        return this.bkup_uri;
    }

    @Override
    public void startDocument() throws SAXException {
        this.currentStatus = 0;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        try {
            if (XML_TAG_URI.equals(qName)) {
                int i = 0;
                while (i < attr.getLength()) {
                    if (XML_ATTR_URI.equals(attr.getQName(i))) {
                        this.bkup_uri = attr.getValue(i);
                    }
                    ++i;
                }
                this.currentStatus = 1;
            } else if (XML_TAG_ITEM.equals(qName)) {
                this.currentStatus = 2;
                this.currentChildStatus = 0;
                this.bkup_start = "00:00:000";
                this.bkup_duration = "00:00:000";
                this.bkup_desc = "";
                this.bkup_extended = "false";
                this.bkup_speed = "50";
                this.bkup_gender = "male";
                this.bkup_lang = "en";
                this.statWavTag = false;
                this.bkup_wav_ena = false;
                this.bkup_wav_uri = URI_BLANK;
                this.bkup_wav_loc = null;
                this.bkup_wav_duration = "00:00:000";
                this.bkup_wav_speed = "100";
            } else if (XML_TAG_START.equals(qName)) {
                this.currentChildStatus = 3;
            } else if ("duration".equals(qName)) {
                this.currentChildStatus = 4;
            } else if (XML_TAG_DESC.equals(qName)) {
                int i = 0;
                while (i < attr.getLength()) {
                    if (XML_ATTR_SPEED.equals(attr.getQName(i))) {
                        this.bkup_speed = attr.getValue(i);
                    } else if (XML_ATTR_GENDER.equals(attr.getQName(i))) {
                        this.bkup_gender = attr.getValue(i);
                    } else if (XML_ATTR_EXTENDED.equals(attr.getQName(i))) {
                        this.bkup_extended = attr.getValue(i);
                    } else if (XML_ATTR_LANG.equals(attr.getQName(i))) {
                        this.bkup_lang = attr.getValue(i);
                    }
                    ++i;
                }
                this.currentChildStatus = 5;
            } else if (XML_TAG_WAVE.equals(qName)) {
                this.bkup_wav_ena = true;
                int i = 0;
                while (i < attr.getLength()) {
                    if (XML_ATTR_URI.equals(attr.getQName(i))) {
                        this.bkup_wav_uri = attr.getValue(i);
                    } else if (XML_ATTR_LOCAL.equals(attr.getQName(i))) {
                        this.bkup_wav_loc = attr.getValue(i);
                    } else if ("duration".equals(attr.getQName(i))) {
                        this.bkup_wav_duration = attr.getValue(i);
                    } else if (XML_ATTR_SPEED.equals(attr.getQName(i))) {
                        this.bkup_wav_speed = attr.getValue(i);
                    } else if (XML_ATTR_ENABLED.equals(attr.getQName(i))) {
                        this.bkup_wav_ena = !attr.getValue(i).equals("false");
                    }
                    ++i;
                }
                this.currentChildStatus = 6;
                this.statWavTag = true;
            } else if (XML_TAG_VOLLVL.equals(qName)) {
                int i = 0;
                while (i < attr.getLength()) {
                    if (XML_ATTR_LOCAL.equals(attr.getQName(i))) {
                        this.bkup_vollvl_loc = attr.getValue(i);
                    }
                    ++i;
                }
                this.currentStatus = 8;
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void characters(char[] ch, int offset, int length) throws SAXException {
        if (this.currentChildStatus == 3 && this.currentStatus == 2) {
            this.bkup_start = new String(ch, offset, length);
        } else if (this.currentChildStatus == 4 && this.currentStatus == 2) {
            this.bkup_duration = new String(ch, offset, length);
        } else if (this.currentChildStatus == 5 && this.currentStatus == 2) {
            this.bkup_desc = String.valueOf(this.bkup_desc) + new String(ch, offset, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (XML_TAG_ITEM.equals(qName) && this.currentStatus == 2) {
            String strPitch = new String("50");
            String strVolume = new String("50");
            this.instParent.appendScriptData(this.bkup_start, this.bkup_duration, this.bkup_desc, this.bkup_extended, this.bkup_gender, this.bkup_speed, strPitch, strVolume, this.bkup_lang);
            if (this.statWavTag) {
                this.instParent.appendDataWavList(this.bkup_start, this.bkup_wav_duration, this.bkup_wav_loc, this.bkup_wav_speed, this.bkup_wav_ena);
                this.statWavTag = false;
            }
            this.currentStatus = 0;
            this.currentChildStatus = 0;
        } else if (XML_TAG_START.equals(qName) && this.currentStatus == 2) {
            this.currentChildStatus = 0;
        } else if ("duration".equals(qName) && this.currentStatus == 2) {
            this.currentChildStatus = 0;
        } else if (XML_TAG_DESC.equals(qName) && this.currentStatus == 2) {
            this.currentChildStatus = 0;
        } else if (XML_TAG_URI.equals(qName) && this.currentStatus == 1) {
            this.currentStatus = 0;
        } else if (XML_TAG_VOLLVL.equals(qName) && this.currentStatus == 8) {
            if (this.bkup_vollvl_loc != null) {
                try {
                    VolumeLevelCanvas.getInstance().setSavePathVolLvl(this.bkup_vollvl_loc);
                }
                catch (Exception exception) {}
            }
            this.currentStatus = 0;
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.currentStatus = 0;
    }
}

