/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.flash.as;

public class ASSerializer {
    public static String serialize(String str) {
        if (str.indexOf(34) >= 0 || str.indexOf(92) >= 0) {
            StringBuffer ret = new StringBuffer(34);
            int i = 0;
            while (i < str.length()) {
                char ch = str.charAt(i);
                switch (ch) {
                    case '\"': {
                        ret.append("\\\"");
                        break;
                    }
                    case '\\': {
                        ret.append("\\\\");
                        break;
                    }
                    default: {
                        ret.append(ch);
                    }
                }
                ++i;
            }
            ret.append('\"');
            return ret.toString();
        }
        return "\"" + str + "\"";
    }

    private static String serialize(Object a) {
        if (a instanceof String) {
            return ASSerializer.serialize((String)a);
        }
        if (a instanceof Number) {
            return a.toString();
        }
        if (a instanceof Boolean) {
            return a.toString();
        }
        if (a instanceof Object[]) {
            StringBuffer ret = new StringBuffer();
            Object[] objectArray = (Object[])a;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object tmp = objectArray[n2];
                ret.append(ASSerializer.serialize(tmp));
                ret.append(",");
                ++n2;
            }
            if (ret.length() > 1) {
                return ret.substring(0, ret.length() - 2);
            }
            return "";
        }
        throw new IllegalArgumentException(a + " cannot be serialized.");
    }

    public static String serialize(String secret, Object[] args) {
        StringBuffer ret = new StringBuffer(secret);
        ret.append('[');
        if (args.length > 0) {
            ret.append(ASSerializer.serialize(args[0]));
            int i = 1;
            while (i < args.length) {
                ret.append(",");
                Object a = args[i];
                ret.append(ASSerializer.serialize(a));
                ++i;
            }
        }
        ret.append("]");
        return ret.toString();
    }
}

