/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.core;

import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.eclipse.actf.core.config.IConfiguration;
import org.eclipse.actf.core.runtime.IRuntimeContext;
import org.eclipse.actf.core.runtime.RuntimeContextFactory;
import org.eclipse.actf.util.resources.ClassLoaderCache;
import org.eclipse.actf.util.resources.EclipseResourceLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class ActfCorePlugin
extends Plugin {
    public static final String ACTFCORE_PLUGIN_ID = "org.eclipse.actf.core";
    protected IRuntimeContext runtimeContext;
    protected IConfiguration configuration;
    protected ClassLoaderCache clCache = ClassLoaderCache.getDefault();
    private Logger logger = Logger.getLogger("org.eclipse.actf.core");
    private static ActfCorePlugin plugin;

    protected String getPluginId() {
        return ACTFCORE_PLUGIN_ID;
    }

    public static ActfCorePlugin getDefault() {
        if (plugin == null) {
            plugin = new ActfCorePlugin();
        }
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.runtimeContext = RuntimeContextFactory.getInstance().getRuntimeContext();
        this.configuration = this.runtimeContext.getConfiguration();
        EclipseResourceLocator locator = (EclipseResourceLocator)this.runtimeContext.getResourceLocator();
        locator.registerBundleName(this.getPluginId());
        this.clCache.put(this.getPluginId(), ((Object)((Object)this)).getClass().getClassLoader());
        String logging = System.getProperty("java.util.logging.config.file");
        if (logging == null) {
            LogManager logManager = LogManager.getLogManager();
            EclipseResourceLocator resourceLocator = (EclipseResourceLocator)this.runtimeContext.getResourceLocator();
            resourceLocator.registerBundleName(ACTFCORE_PLUGIN_ID);
            InputStream ins = resourceLocator.getResourceAsStream("logging", "\\", "properties", ACTFCORE_PLUGIN_ID);
            if (ins != null) {
                logManager.readConfiguration(ins);
            }
        }
        this.logger.log(Level.INFO, String.valueOf(((Object)((Object)this)).getClass().getName()) + " started");
        this.logger.log(Level.INFO, "configuration:" + this.configuration);
    }

    public IRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public void logException(String message, Throwable t) {
        String tname = t.getClass().getName();
        String msg = t.getMessage();
        msg = msg != null && msg.length() > 0 ? String.valueOf(tname) + " - " + msg : tname;
        this.logger.log(Level.SEVERE, message != null ? message : "<No message>", t);
    }

    public void logException(Throwable t) {
        String msg = t.getMessage();
        this.logger.log(Level.SEVERE, msg != null && msg.length() > 0 ? msg : "<no message>", t);
    }

    public void stop(BundleContext context) throws Exception {
        this.logger.log(Level.INFO, String.valueOf(((Object)((Object)this)).getClass().getName()) + " stopped");
        super.stop(context);
    }

    public boolean isDebugging(String option) {
        String value = Platform.getDebugOption((String)option);
        return super.isDebugging() && value != null && "true".equalsIgnoreCase(value);
    }
}

