/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.resources;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ClassLoaderCache {
    private static ClassLoaderCache _clc;
    private Map _cache = Collections.synchronizedMap(new HashMap());

    protected ClassLoaderCache() {
    }

    public static ClassLoaderCache getDefault() {
        if (_clc == null) {
            _clc = new ClassLoaderCache();
        }
        return _clc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getResource(String name) {
        URL result = this.getClass().getClassLoader().getResource(name);
        if (result == null) {
            Map map = this._cache;
            synchronized (map) {
                Iterator iter = this._cache.values().iterator();
                while (iter.hasNext() && result == null) {
                    ClassLoader loader = (ClassLoader)iter.next();
                    if (loader == null) continue;
                    result = loader.getResource(name);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getResources(String name) throws IOException {
        Enumeration<URL> result = this.getClass().getClassLoader().getResources(name);
        if (result == null) {
            Map map = this._cache;
            synchronized (map) {
                Iterator iter = this._cache.values().iterator();
                while (iter.hasNext() && result == null) {
                    ClassLoader loader = (ClassLoader)iter.next();
                    if (loader == null) continue;
                    result = loader.getResources(name);
                }
            }
        }
        return result;
    }

    public Class classForName(String className) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className, true, this.getClassLoaderFor(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoaderFor(String className) {
        ClassLoader cl = (ClassLoader)this._cache.get(className);
        int dot = className.lastIndexOf(46);
        String packPrefix = dot == -1 ? "" : className.substring(0, dot);
        while (cl == null & packPrefix.length() > 0) {
            Map map = this._cache;
            synchronized (map) {
                Iterator iter = this._cache.keySet().iterator();
                while (iter.hasNext() & cl == null) {
                    String key = (String)iter.next();
                    if (key.indexOf(packPrefix) < 0) continue;
                    cl = (ClassLoader)this._cache.get(key);
                }
            }
            dot = packPrefix.lastIndexOf(46);
            packPrefix = dot == -1 ? "" : packPrefix.substring(0, dot);
        }
        return cl != null ? cl : this.getClass().getClassLoader();
    }

    public void put(String className, ClassLoader cl) {
        if (this._cache.containsKey(className)) {
            throw new IllegalArgumentException("Duplicate entries in cache");
        }
        this._cache.put(className, cl);
    }

    public boolean isAssignableFrom(String className, Class testCls) {
        Class<?> cls = null;
        boolean result = false;
        try {
            cls = Class.forName(className, true, this.getClassLoaderFor(className));
            result = cls.isAssignableFrom(testCls);
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return result;
    }

    public boolean isInstanceOf(String className, Object o) {
        return this.isAssignableFrom(className, o.getClass());
    }

    public boolean isNonAdvisableClassName(String classname) {
        return classname.startsWith("org.aspectj") || classname.startsWith("org.apache.") || classname.startsWith("org.mozilla.javascript.") || classname.startsWith("org.xml.sax.") || classname.startsWith("sunw.") || classname.startsWith("sun.") || classname.startsWith("java.") && !classname.startsWith("java.awt.") || classname.startsWith("javax.") && !classname.startsWith("javax.swing.") || classname.startsWith("com.sun.") || classname.startsWith("com.ibm.sns.") || classname.startsWith("org.eclipse.actf.");
    }
}

