/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.tmf.core.component.TmfEventProvider;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfIterator;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfLocation;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemQuerier;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

public class CtfTmfTrace
extends TmfEventProvider<CtfTmfEvent>
implements ITmfTrace<CtfTmfEvent> {
    private CTFTrace fTrace;
    protected long fNbEvents = 0L;
    private ITmfTimestamp fStartTime = TmfTimestamp.BIG_CRUNCH;
    private ITmfTimestamp fEndTime = TmfTimestamp.BIG_BANG;
    private IResource fResource;
    protected CtfIterator iterator;
    protected IStateSystemQuerier ss = null;

    @Override
    public void initTrace(IResource resource, String path, Class<CtfTmfEvent> eventType) throws TmfTraceException {
        this.fResource = resource;
        try {
            this.fTrace = new CTFTrace(path);
        }
        catch (CTFReaderException e) {
            throw new TmfTraceException(e.getMessage());
        }
        this.iterator = new CtfIterator(this, 0L, 0L);
        this.setStartTime(TmfTimestamp.BIG_BANG);
        if (!this.iterator.getLocation().equals(CtfIterator.nullLocation)) {
            this.setStartTime(this.iterator.getCurrentEvent().getTimestamp());
        }
        TmfSignalManager.register(this);
        this.buildStateSystem();
        if (resource != null) {
            try {
                resource.getProject().refreshLocal(2, null);
            }
            catch (CoreException e) {
                throw new TmfTraceException(e.getMessage());
            }
        }
    }

    @Override
    public void dispose() {
        TmfSignalManager.deregister(this);
    }

    @Override
    public void broadcast(TmfSignal signal) {
        TmfSignalManager.dispatchSignal(signal);
    }

    @Override
    public boolean validate(IProject project, String path) {
        try {
            CTFTrace temp = new CTFTrace(path);
            return temp.majortIsSet();
        }
        catch (CTFReaderException cTFReaderException) {
            return false;
        }
    }

    @Override
    public Class<CtfTmfEvent> getEventType() {
        return this.fType;
    }

    public int getNbEnvVars() {
        return this.fTrace.getEnvironment().size();
    }

    public String[] getEnvNames() {
        String[] s = new String[this.getNbEnvVars()];
        return this.fTrace.getEnvironment().keySet().toArray(s);
    }

    public String getEnvValue(String key) {
        return (String)this.fTrace.getEnvironment().get(key);
    }

    @Override
    public String getPath() {
        return this.fTrace.getPath();
    }

    @Override
    public String getName() {
        String traceName;
        String string = traceName = this.fResource != null ? this.fResource.getName() : null;
        if (traceName == null) {
            String path = this.fTrace.getPath();
            int sep = path.lastIndexOf(47);
            traceName = sep >= 0 ? path.substring(sep + 1) : path;
        }
        return traceName;
    }

    @Override
    public int getCacheSize() {
        return 50000;
    }

    @Override
    public long getNbEvents() {
        return this.fNbEvents;
    }

    @Override
    public TmfTimeRange getTimeRange() {
        return new TmfTimeRange(this.fStartTime, this.fEndTime);
    }

    @Override
    public ITmfTimestamp getStartTime() {
        return this.fStartTime;
    }

    @Override
    public ITmfTimestamp getEndTime() {
        return this.fEndTime;
    }

    @Override
    public ITmfLocation<?> getCurrentLocation() {
        return this.iterator.getLocation();
    }

    protected void setTimeRange(TmfTimeRange range) {
        this.fStartTime = range.getStartTime();
        this.fEndTime = range.getEndTime();
    }

    protected void setStartTime(ITmfTimestamp startTime) {
        this.fStartTime = startTime;
    }

    protected void setEndTime(ITmfTimestamp endTime) {
        this.fEndTime = endTime;
    }

    @Override
    public ITmfContext armRequest(ITmfDataRequest<CtfTmfEvent> request) {
        if (request instanceof ITmfEventRequest && !TmfTimestamp.BIG_BANG.equals(((ITmfEventRequest)request).getRange().getStartTime()) && request.getIndex() == 0) {
            ITmfContext context = this.seekEvent(((ITmfEventRequest)request).getRange().getStartTime());
            ((ITmfEventRequest)request).setStartIndex((int)context.getRank());
            return context;
        }
        return this.seekEvent(request.getIndex());
    }

    @Override
    public CtfTmfEvent getNext(ITmfContext context) {
        this.iterator.advance();
        return this.iterator.getCurrentEvent();
    }

    @Override
    public ITmfContext seekEvent(ITmfLocation<?> location) {
        CtfLocation currentLocation = (CtfLocation)location;
        if (currentLocation == null) {
            currentLocation = new CtfLocation(0L);
        }
        if (!this.iterator.getLocation().equals(CtfIterator.nullLocation)) {
            this.iterator.setLocation((ITmfLocation<?>)currentLocation);
        }
        return this.iterator;
    }

    @Override
    public double getLocationRatio(ITmfLocation<?> location) {
        CtfLocation curLocation = (CtfLocation)location;
        this.iterator.seek(curLocation.getLocation());
        return ((double)this.iterator.getCurrentEvent().getTimestampValue() - (double)this.iterator.getStartTime()) / (double)(this.iterator.getEndTime() - this.iterator.getStartTime());
    }

    @Override
    public long getStreamingInterval() {
        return 0L;
    }

    @Override
    public ITmfContext seekEvent(ITmfTimestamp timestamp) {
        this.iterator.seek(timestamp.getValue());
        return this.iterator;
    }

    @Override
    public ITmfContext seekEvent(long rank) {
        this.iterator.setRank(rank);
        return this.iterator;
    }

    @Override
    public ITmfContext seekEvent(double ratio) {
        this.iterator.seek((long)((double)this.fNbEvents * ratio));
        return this.iterator;
    }

    @Override
    public CtfTmfEvent readNextEvent(ITmfContext context) {
        this.iterator.advance();
        return this.iterator.getCurrentEvent();
    }

    @Override
    public IResource getResource() {
        return this.fResource;
    }

    public IStateSystemQuerier getStateSystem() {
        return this.ss;
    }

    CTFTrace getCTFTrace() {
        return this.fTrace;
    }

    protected void buildStateSystem() throws TmfTraceException {
    }
}

