/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui;

import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.preferences.ControlPreferences;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.lttng2.ui";
    private static Activator plugin;

    public static Activator getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ControlPreferences.getInstance().init(this.getPreferenceStore());
    }

    public void stop(BundleContext context) throws Exception {
        ControlPreferences.getInstance().dispose();
        plugin = null;
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
    }

    public Image getImageFromPath(String path) {
        return this.getImageDescripterFromPath(path).createImage();
    }

    public ImageDescriptor getImageDescripterFromPath(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public Image getImageFromImageRegistry(String path) {
        Image icon = this.getImageRegistry().get(path);
        if (icon == null) {
            icon = this.getImageDescripterFromPath(path).createImage();
            plugin.getImageRegistry().put(path, icon);
        }
        return icon;
    }

    public Image loadIcon(String url) {
        String key = String.valueOf(plugin.getBundle().getSymbolicName()) + "/" + url;
        Image icon = plugin.getImageRegistry().get(key);
        if (icon == null) {
            URL imageURL = plugin.getBundle().getResource(url);
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)imageURL);
            icon = descriptor.createImage();
            plugin.getImageRegistry().put(key, icon);
        }
        return icon;
    }

    public void logInfo(String message) {
        this.getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public void logInfo(String message, Throwable exception) {
        this.getLog().log((IStatus)new Status(1, PLUGIN_ID, message, exception));
    }

    public void logWarning(String message) {
        this.getLog().log((IStatus)new Status(2, PLUGIN_ID, message));
    }

    public void logWarning(String message, Throwable exception) {
        this.getLog().log((IStatus)new Status(2, PLUGIN_ID, message, exception));
    }

    public void logError(String message) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, message));
    }

    public void logError(String message, Throwable exception) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, message, exception));
    }
}

