/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.editor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.systemtap.ui.editor.PathEditorInput;
import org.eclipse.linuxtools.systemtap.ui.editor.RecentFileMenuManager;
import org.eclipse.linuxtools.systemtap.ui.editor.SimpleDocumentProvider;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class SimpleEditor
extends TextEditor {
    public static final String ID = "org.eclipse.linuxtools.systemtap.ui.editor.SimpleEditor";

    public SimpleEditor() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.ui.textEditorScope"});
        this.internal_init();
    }

    protected void internal_init() {
        this.configureInsertMode(SMART_INSERT, false);
        this.setDocumentProvider((IDocumentProvider)new SimpleDocumentProvider());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        RecentFileMenuManager.getInstance().registerActionBar(this.getEditorSite().getActionBars());
    }

    public int find(String search) {
        IDocument doc = this.getSourceViewer().getDocument();
        FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(doc);
        int line = 0;
        this.jumpToLocation(0, 0);
        try {
            IRegion reg = finder.find(0, search, true, false, false, false);
            int offset = reg.getOffset();
            line = doc.getLineOfOffset(offset);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (NullPointerException nullPointerException) {
            line = -1;
        }
        return line;
    }

    public void jumpToLocation(int line, int character) {
        IDocument doc = this.getSourceViewer().getDocument();
        try {
            int offset = doc.getLineOffset(line - 1) + character;
            this.getSelectionProvider().setSelection((ISelection)new TextSelection(doc, offset, 0));
        }
        catch (BadLocationException badLocationException) {}
    }

    public void selectLine(int line) {
        IDocument doc = this.getSourceViewer().getDocument();
        try {
            this.getSelectionProvider().setSelection((ISelection)new TextSelection(doc, doc.getLineOffset(line - 1), doc.getLineLength(line - 1) - 1));
        }
        catch (BadLocationException badLocationException) {}
    }

    public void doSaveAs() {
        File file = this.queryFile();
        if (file == null) {
            return;
        }
        IEditorInput inputFile = this.createEditorInput(file);
        IDocument doc = this.getSourceViewer().getDocument();
        String s = doc.get();
        try {
            FileOutputStream fos = new FileOutputStream(file);
            PrintStream ps = new PrintStream(fos);
            ps.print(s);
            ps.close();
        }
        catch (FileNotFoundException fileNotFoundException) {}
        this.setInput(inputFile);
        this.setPartName(inputFile.getName());
    }

    private IEditorInput createEditorInput(File file) {
        Path location = new Path(file.getAbsolutePath());
        PathEditorInput input = new PathEditorInput((IPath)location);
        return input;
    }

    public void insertText(String text) {
        IDocument doc = this.getSourceViewer().getDocument();
        String s = doc.get();
        int offset = s.length();
        s = String.valueOf(s) + text;
        doc.set(s);
        this.setHighlightRange(offset, 0, true);
    }

    public void insertTextAtCurrent(String text) {
        ISelection selection = this.getSelectionProvider().getSelection();
        IDocument doc = this.getSourceViewer().getDocument();
        if (selection instanceof ITextSelection) {
            ITextSelection s = (ITextSelection)selection;
            StringBuffer sb = new StringBuffer(doc.get().substring(0, s.getOffset()));
            sb.append(text.trim());
            sb.append(doc.get().substring(s.getOffset() + s.getLength(), doc.get().length()));
            doc.set(sb.toString());
            this.setHighlightRange(s.getOffset() + text.trim().length(), 0, true);
        }
    }

    private File queryFile() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        dialog.setText("New File");
        String path = dialog.open();
        if (path != null && path.length() > 0) {
            return new File(path);
        }
        return null;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }
}

