/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.stream.Stream;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;

public final class SymbolUtils {
    private static final Range DEFAULT_RANGE = new Range(new Position(0, 0), new Position(0, 0));

    static IJavaElement[] filter(IJavaElement[] elements) {
        return (IJavaElement[])Stream.of(elements).filter(e -> !SymbolUtils.isInitializer(e) && !SymbolUtils.isSyntheticElement(e)).toArray(IJavaElement[]::new);
    }

    private static boolean isInitializer(IJavaElement element) {
        String name;
        return element.getElementType() == 9 && (name = element.getElementName()) != null && name.indexOf(60) >= 0;
    }

    private static boolean isSyntheticElement(IJavaElement element) {
        if (!(element instanceof IMember)) {
            return false;
        }
        IMember member = (IMember)element;
        if (!member.isBinary()) {
            return false;
        }
        try {
            return Flags.isSynthetic((int)member.getFlags());
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    public static SymbolKind mapKind(IJavaElement element) {
        switch (element.getElementType()) {
            case 7: {
                try {
                    IType type = (IType)element;
                    if (type.isInterface()) {
                        return SymbolKind.Interface;
                    }
                    if (type.isEnum()) {
                        return SymbolKind.Enum;
                    }
                }
                catch (JavaModelException type) {
                    // empty catch block
                }
                return SymbolKind.Class;
            }
            case 16: {
                return SymbolKind.Property;
            }
            case 5: 
            case 6: {
                return SymbolKind.File;
            }
            case 8: {
                IField field = (IField)element;
                try {
                    if (field.isEnumConstant()) {
                        return SymbolKind.EnumMember;
                    }
                    int flags = field.getFlags();
                    if (Flags.isStatic((int)flags) && Flags.isFinal((int)flags)) {
                        return SymbolKind.Constant;
                    }
                }
                catch (JavaModelException flags) {
                    // empty catch block
                }
                return SymbolKind.Field;
            }
            case 12: 
            case 13: 
            case 17: {
                return SymbolKind.Module;
            }
            case 10: {
                return SymbolKind.Constructor;
            }
            case 14: {
                return SymbolKind.Variable;
            }
            case 15: {
                return SymbolKind.TypeParameter;
            }
            case 9: {
                try {
                    IMethod method;
                    if (element instanceof IMethod && (method = (IMethod)element).isConstructor()) {
                        return SymbolKind.Constructor;
                    }
                    return SymbolKind.Method;
                }
                catch (JavaModelException e) {
                    return SymbolKind.Method;
                }
            }
            case 4: 
            case 11: {
                return SymbolKind.Package;
            }
        }
        return SymbolKind.String;
    }

    static String getName(IJavaElement element) {
        String name = JavaElementLabelsCore.getElementLabel((IJavaElement)element, (long)0x200009L);
        return name == null ? element.getElementName() : name;
    }

    static Range getRange(IJavaElement element) throws JavaModelException {
        Location location = JDTUtils.toLocation(element, JDTUtils.LocationType.FULL_RANGE);
        return location == null ? DEFAULT_RANGE : location.getRange();
    }

    static Range getSelectionRange(IJavaElement element) throws JavaModelException {
        Location location = JDTUtils.toLocation(element);
        return location == null ? DEFAULT_RANGE : location.getRange();
    }

    static String getDetail(IJavaElement element, String name) {
        return SymbolUtils.constructDetail(element, name, 1099513724969L);
    }

    static String getDetail(IJavaElement element, String name, long additionalFlags) {
        return SymbolUtils.constructDetail(element, name, 0x10000200009L | additionalFlags);
    }

    private static String constructDetail(IJavaElement element, String name, long flags) {
        String nameWithDetails = JavaElementLabelsCore.getElementLabel((IJavaElement)element, (long)flags);
        if (nameWithDetails != null && nameWithDetails.startsWith(name)) {
            return nameWithDetails.substring(name.length());
        }
        return "";
    }
}

