/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.supports;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CharacterPair;
import org.eclipse.tm4e.languageconfiguration.internal.supports.Comments;

public final class CommentSupport {
    private final @Nullable Comments comments;

    public CommentSupport(@Nullable Comments comments) {
        this.comments = comments;
    }

    private boolean isInComment(IDocument document, int offset) {
        block3: {
            try {
                if (!this.isInBlockComment(document.get(0, offset))) break block3;
                return true;
            }
            catch (BadLocationException e) {
                return false;
            }
        }
        int line = document.getLineOfOffset(offset);
        int lineOffset = document.getLineOffset(line);
        return this.isInLineComment(document.get(lineOffset, offset - lineOffset));
    }

    public @Nullable String getLineComment() {
        Comments comments = this.comments;
        return comments == null ? null : comments.getLineComment();
    }

    public @Nullable CharacterPair getBlockComment() {
        Comments comments = this.comments;
        return comments == null ? null : comments.getBlockComment();
    }

    private boolean isInLineComment(String indexLinePrefix) {
        Comments comments = this.comments;
        if (comments == null) {
            return false;
        }
        return indexLinePrefix.indexOf(comments.getLineComment()) != -1;
    }

    private boolean isInBlockComment(String indexPrefix) {
        Comments comments = this.comments;
        if (comments == null) {
            return false;
        }
        CharacterPair blockComment = comments.getBlockComment();
        if (blockComment == null) {
            return false;
        }
        String commentOpen = (String)blockComment.getKey();
        String commentClose = (String)blockComment.getValue();
        int index = indexPrefix.indexOf(commentOpen);
        while (index != -1 && index < indexPrefix.length()) {
            int closeIndex = indexPrefix.indexOf(commentClose, index + commentOpen.length());
            if (closeIndex == -1) {
                return true;
            }
            index = indexPrefix.indexOf(commentOpen, closeIndex + commentClose.length());
        }
        return false;
    }
}

