/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view.action;

import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.ui.view.TraceView;
import org.eclipse.trace4cps.ui.view.action.AbstractTraceViewAction;
import org.eclipse.trace4cps.vis.jfree.ClaimScaling;

public class ToggleClaimScaleAction
extends AbstractTraceViewAction {
    public ToggleClaimScaleAction(TraceView view) {
        super(view, "/icons/keygroups_obj.png");
        this.setChecked(this.viewCfg.getClaimScaling() == ClaimScaling.FULL);
    }

    public String getToolTipText() {
        switch (this.viewCfg.getClaimScaling()) {
            case FULL: {
                return "Switch claim scaling to NONE";
            }
            case NONE: {
                return "Switch claim scaling to FULL";
            }
        }
        return "Switch claim scaling";
    }

    public int getStyle() {
        return 2;
    }

    public boolean isEnabled() {
        return this.viewCfg.isActivityView() && this.view.hasClaims(true);
    }

    @Override
    protected void doRun() throws TraceException {
        if (this.isChecked()) {
            this.viewCfg.setClaimScaling(ClaimScaling.FULL);
        } else {
            this.viewCfg.setClaimScaling(ClaimScaling.NONE);
        }
        this.view.update();
    }
}

