/*
 * Copyright (c) 2021, 2025 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.trace4cps.core.impl;

import java.util.TreeSet;

import org.eclipse.trace4cps.core.ITSPoints;
import org.eclipse.trace4cps.core.ITSSeries;

/**
 * Default implementation of the {@link ITSSeries} type.
 */
public final class TSSeries extends AttributeAware implements ITSSeries {
    private TreeSet<ITSPoints> data = new TreeSet<>();

    /**
     * {@inheritDoc}
     */
    @Override
    public void addData(ITSPoints data) {
        this.data.add(data);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Iterable<ITSPoints> getData() {
        return data;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int getSize() {
        return data.size();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Double getStartTime() {
        if (data.isEmpty()) {
            return null;
        } else {
            return data.getFirst().getFirstTimeStamp();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Double getEndTime() {
        if (data.isEmpty()) {
            return null;
        } else {
            return data.getLast().getLastTimeStamp();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isEmpty() {
        return data.isEmpty();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return "TSSeries[attributes=" + getAttributes() + "]";
    }
}
