/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.dnd;

import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.IScriptEngineProvider;
import org.eclipse.ease.Logger;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.dnd.IShellDropHandler;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.ResourceTransfer;

public final class ShellDropTarget
extends DropTargetAdapter {
    private static final String EXTENSION_DROP_HANDLER_ID = "org.eclipse.ease.ui.shell";
    private static final String DROP_HANDLER = "dropHandler";
    private static final String PARAMETER_CLASS = "class";
    protected static final String ATTRIBUTE_PRIORITY = "priority";
    private final IScriptEngineProvider fScriptEngineProvider;

    /*
     * WARNING - void declaration
     */
    private static Collection<IShellDropHandler> getDropTargetListeners() {
        void var3_6;
        IConfigurationElement[] config;
        ArrayList<AbstractMap.SimpleEntry<Integer, IShellDropHandler>> candidates = new ArrayList<AbstractMap.SimpleEntry<Integer, IShellDropHandler>>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_DROP_HANDLER_ID);
        int n = config.length;
        boolean n2 = false;
        while (var3_6 < n) {
            block8: {
                IConfigurationElement e = iConfigurationElementArray[var3_6];
                if (e.getName().equals(DROP_HANDLER)) {
                    try {
                        Object executable = e.createExecutableExtension(PARAMETER_CLASS);
                        if (!(executable instanceof IShellDropHandler)) break block8;
                        int priority = 0;
                        try {
                            priority = Integer.parseInt(e.getAttribute(ATTRIBUTE_PRIORITY));
                        }
                        catch (NumberFormatException nullPointerException) {
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        candidates.add(new AbstractMap.SimpleEntry<Integer, IShellDropHandler>(priority, (IShellDropHandler)executable));
                    }
                    catch (CoreException e12) {
                        Logger.error((String)"org.eclipse.ease.ui", (String)("Invalid drop target listener detected in plugin \"" + e.getContributor().getName() + "\""), (Throwable)e12);
                    }
                }
            }
            ++var3_6;
        }
        Collections.sort(candidates, (e1, e2) -> (Integer)e2.getKey() - (Integer)e1.getKey());
        ArrayList<IShellDropHandler> handler = new ArrayList<IShellDropHandler>(candidates.size());
        for (AbstractMap.SimpleEntry simpleEntry : candidates) {
            handler.add((IShellDropHandler)simpleEntry.getValue());
        }
        return handler;
    }

    public static void addDropSupport(Control parent, IScriptEngineProvider engineProvider) {
        DropTarget target = new DropTarget(parent, 3);
        target.setTransfer(new Transfer[]{FileTransfer.getInstance(), ResourceTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new ShellDropTarget(engineProvider));
    }

    private ShellDropTarget(IScriptEngineProvider provider) {
        this.fScriptEngineProvider = provider;
    }

    public void drop(DropTargetEvent event) {
        Object element = this.unpackElement(event.data);
        Collection<IShellDropHandler> listeners = ShellDropTarget.getDropTargetListeners();
        if (!listeners.isEmpty()) {
            for (IShellDropHandler listener : listeners) {
                if (listener.accepts(this.fScriptEngineProvider.getScriptEngine(), element)) {
                    listener.performDrop(this.fScriptEngineProvider.getScriptEngine(), element, event.detail);
                    return;
                }
                if (event.data.equals(element) || !listener.accepts(this.fScriptEngineProvider.getScriptEngine(), event.data)) continue;
                listener.performDrop(this.fScriptEngineProvider.getScriptEngine(), event.data, event.detail);
                return;
            }
        }
        if (element instanceof IResource) {
            element = ResourceTools.toAbsoluteLocation((Object)element, null);
        }
        this.fScriptEngineProvider.getScriptEngine().execute((Object)element.toString());
    }

    private Object unpackElement(Object element) {
        if (element instanceof String[]) {
            File[] files = new File[((String[])element).length];
            int i = 0;
            while (i < files.length) {
                files[i] = new File(((String[])element)[i]);
                ++i;
            }
            element = files;
        }
        if (element instanceof IStructuredSelection) {
            element = ((IStructuredSelection)element).toArray();
        }
        if (element instanceof Object[] && ((Object[])element).length == 1) {
            element = element[0];
        }
        if (element instanceof Collection && ((Collection)element).size() == 1) {
            element = ((Collection)element).iterator().next();
        }
        return element;
    }
}

