/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.subscribers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.team.core.mapping.ISynchronizationScopeParticipant;
import org.eclipse.team.core.mapping.ISynchronizationScopeParticipantFactory;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.ISubscriberChangeListener;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberResourceMappingContext;

public class SubscriberScopeManager
extends SynchronizationScopeManager
implements ISubscriberChangeListener {
    private final Subscriber subscriber;
    private Map<ModelProvider, ISynchronizationScopeParticipant> participants = new HashMap<ModelProvider, ISynchronizationScopeParticipant>();

    public SubscriberScopeManager(String name, ResourceMapping[] inputMappings, Subscriber subscriber, boolean consultModels) {
        this(name, inputMappings, subscriber, SubscriberResourceMappingContext.createContext(subscriber), consultModels);
    }

    public SubscriberScopeManager(String name, ResourceMapping[] inputMappings, Subscriber subscriber, RemoteResourceMappingContext context, boolean consultModels) {
        super(name, inputMappings, (ResourceMappingContext)context, consultModels);
        this.subscriber = subscriber;
    }

    protected Subscriber getSubscriber() {
        return this.subscriber;
    }

    @Override
    public void dispose() {
        for (ISynchronizationScopeParticipant participant : this.participants.values()) {
            participant.dispose();
        }
        super.dispose();
    }

    @Override
    public void initialize(IProgressMonitor monitor) throws CoreException {
        ResourcesPlugin.getWorkspace().run(monitor1 -> {
            SubscriberScopeManager.super.initialize(monitor1);
            this.hookupParticipants();
            this.getSubscriber().addListener(this);
        }, this.getSchedulingRule(), 0, monitor);
    }

    @Override
    public ResourceTraversal[] refresh(ResourceMapping[] mappings, IProgressMonitor monitor) throws CoreException {
        ArrayList result = new ArrayList(1);
        ResourcesPlugin.getWorkspace().run(monitor1 -> {
            result.add(SubscriberScopeManager.super.refresh(mappings, monitor1));
            this.hookupParticipants();
        }, this.getSchedulingRule(), 0, monitor);
        if (result.isEmpty()) {
            return new ResourceTraversal[0];
        }
        return (ResourceTraversal[])result.get(0);
    }

    void hookupParticipants() {
        ModelProvider[] modelProviderArray = this.getScope().getModelProviders();
        int n = modelProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISynchronizationScopeParticipant p;
            ModelProvider provider = modelProviderArray[n2];
            if (!this.participants.containsKey(provider) && (p = this.createParticipant(provider)) != null) {
                this.participants.put(provider, p);
            }
            ++n2;
        }
    }

    private ISynchronizationScopeParticipant createParticipant(ModelProvider provider) {
        Object factoryObject = provider.getAdapter(ISynchronizationScopeParticipantFactory.class);
        if (factoryObject instanceof ISynchronizationScopeParticipantFactory) {
            ISynchronizationScopeParticipantFactory factory = (ISynchronizationScopeParticipantFactory)factoryObject;
            return factory.createParticipant(provider, this.getScope());
        }
        return null;
    }

    @Override
    public void subscriberResourceChanged(ISubscriberChangeEvent[] deltas) {
        ArrayList<IResource> changedResources = new ArrayList<IResource>();
        ArrayList<IProject> changedProjects = new ArrayList<IProject>();
        ISubscriberChangeEvent[] iSubscriberChangeEventArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            ISubscriberChangeEvent event = iSubscriberChangeEventArray[n2];
            if ((event.getFlags() & 6) != 0) {
                changedProjects.add(event.getResource().getProject());
            }
            if ((event.getFlags() & 1) != 0) {
                changedResources.add(event.getResource());
            }
            ++n2;
        }
        this.fireChange(changedResources.toArray(new IResource[changedResources.size()]), changedProjects.toArray(new IProject[changedProjects.size()]));
    }

    private void fireChange(final IResource[] resources, final IProject[] projects) {
        final HashSet result = new HashSet();
        for (final ISynchronizationScopeParticipant participant : this.participants.values()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ResourceMapping[] resourceMappingArray = participant.handleContextChange(SubscriberScopeManager.this.getScope(), resources, projects);
                    int n = resourceMappingArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ResourceMapping mapping = resourceMappingArray[n2];
                        result.add(mapping);
                        ++n2;
                    }
                }

                public void handleException(Throwable exception) {
                }
            });
        }
        if (!result.isEmpty()) {
            this.refresh(result.toArray(new ResourceMapping[result.size()]));
        }
    }
}

