/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.internal.ui;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.text.quicksearch.internal.core.preferences.QuickSearchPreferences;
import org.eclipse.text.quicksearch.internal.ui.Messages;
import org.eclipse.text.quicksearch.internal.ui.QuickSearchActivator;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class QuickSearchPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String[] prefsKeys = new String[]{"ignored.extensions", "ignored.prefixes", "ignored.names"};
    private static final String[] fieldLabels = new String[]{Messages.QuickSearchPreferencesPage_Ignored_Extensions, Messages.QuickSearchPreferencesPage_Ignored_Prefixes, Messages.QuickSearchPreferencesPage_Ignored_Names};
    private static final String[] toolTips = new String[]{Messages.QuickSearchPreferencesPage_Tooltip_Extensions, Messages.QuickSearchPreferencesPage_Tooltip_Prefixes, Messages.QuickSearchPreferencesPage_Tooltip_Names};

    public QuickSearchPreferencesPage() {
        super(1);
        this.setPreferenceStore(QuickSearchActivator.getDefault().getPreferenceStore());
        QuickSearchPreferences.initializeDefaults();
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        IntegerFieldEditor fieldMaxLineLen = new IntegerFieldEditor("LineReader.MAX_LINE_LEN", Messages.QuickSearchPreferencesPage_MaxLineLength, this.getFieldEditorParent());
        fieldMaxLineLen.getTextControl(this.getFieldEditorParent()).setToolTipText(Messages.QuickSearchPreferencesPage_Tooltip_MaxLineLength);
        this.addField((FieldEditor)fieldMaxLineLen);
        int i = 0;
        while (i < fieldLabels.length) {
            final String tooltip = toolTips[i];
            StringFieldEditor field = new StringFieldEditor(prefsKeys[i], fieldLabels[i], StringFieldEditor.UNLIMITED, 5, 1, this.getFieldEditorParent()){

                protected Text createTextWidget(Composite parent) {
                    Text w = super.createTextWidget(parent);
                    w.setToolTipText(tooltip);
                    return w;
                }

                protected void doFillIntoGrid(Composite parent, int numColumns) {
                    super.doFillIntoGrid(parent, numColumns);
                    Text text = this.getTextControl();
                    GridData layout = (GridData)text.getLayoutData();
                    layout.widthHint = 400;
                    layout.minimumWidth = 100;
                }
            };
            this.addField((FieldEditor)field);
            ++i;
        }
    }
}

