/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public class EaseClassLoader
extends ClassLoader {
    private final Map<Job, URLClassLoader> fRegisteredJars = new HashMap<Job, URLClassLoader>();
    private final Collection<URLClassLoader> fTraversingURLClassLoader = new HashSet<URLClassLoader>();

    public EaseClassLoader() {
        super(((BundleWiring)FrameworkUtil.getBundle(EaseClassLoader.class).adapt(BundleWiring.class)).getClassLoader());
    }

    public EaseClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Job currentJob = Job.getJobManager().currentJob();
        URLClassLoader classLoader = this.fRegisteredJars.get(currentJob);
        if (classLoader != null && !this.fTraversingURLClassLoader.contains(classLoader)) {
            this.fTraversingURLClassLoader.add(classLoader);
            try {
                Class<?> clazz = classLoader.loadClass(name);
                if (clazz != null) {
                    Class<?> clazz2 = clazz;
                    return clazz2;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            finally {
                this.fTraversingURLClassLoader.remove(classLoader);
            }
        }
        return super.findClass(name);
    }

    public void registerURL(Job engine, URL url) {
        if (!this.fRegisteredJars.containsKey(engine)) {
            this.fRegisteredJars.put(engine, URLClassLoader.newInstance(new URL[]{url}, this));
        } else {
            List<URL> urlList = Arrays.asList(this.fRegisteredJars.get(engine).getURLs());
            if (!urlList.contains(url)) {
                urlList.add(url);
                this.fRegisteredJars.put(engine, URLClassLoader.newInstance(urlList.toArray(new URL[0]), this));
            }
        }
    }

    public void unregisterEngine(Job engine) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                URLClassLoader classLoader = this.fRegisteredJars.remove(engine);
                if (classLoader != null) {
                    classLoader.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

