/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.rocm.core.trace;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTraceValidationStatus;

public class RocmCtfTrace
extends CtfTmfTrace {
    private static final Collection<@NonNull ITmfEventAspect<?>> ROCM_CTF_ASPECTS = TmfBaseAspects.getBaseAspects();
    private static final int CONFIDENCE = 100;

    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        return ROCM_CTF_ASPECTS;
    }

    public @Nullable IStatus validate(@Nullable IProject project, @Nullable String path) {
        IStatus status = super.validate(project, path);
        if (status instanceof CtfTraceValidationStatus) {
            Map environment = ((CtfTraceValidationStatus)status).getEnvironment();
            String domain = (String)environment.get("tracer_name");
            if (domain == null || !domain.equals("\"roctracer\"")) {
                return new Status(4, "org.eclipse.tracecompass.incubator.rocm.core", "This trace is not a rocm trace");
            }
            return new TraceValidationStatus(100, "org.eclipse.tracecompass.incubator.rocm.core");
        }
        return status;
    }

    public TmfTraceContext createTraceContext(TmfTimeRange selection, TmfTimeRange windowRange, @Nullable IFile editorFile, @Nullable ITmfFilter filter) {
        return new TmfTraceContext(selection, windowRange, editorFile, filter);
    }
}

