/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.support.manifestwriter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.virgo.bundlor.ManifestWriter;
import org.eclipse.virgo.bundlor.util.BundleManifestUtils;
import org.eclipse.virgo.util.parser.manifest.ManifestContents;

final class FileSystemManifestWriter
implements ManifestWriter {
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private final File manifestFile;

    public FileSystemManifestWriter(File root) {
        this.manifestFile = new File(root, MANIFEST_PATH);
    }

    @Override
    public void write(ManifestContents manifest) {
        Writer out = null;
        try {
            try {
                if (!this.manifestFile.getParentFile().exists() && !this.manifestFile.getParentFile().mkdirs()) {
                    throw new RuntimeException(String.format("Could not create parent directories of '%s'", this.manifestFile.getAbsolutePath()));
                }
                out = new FileWriter(this.manifestFile);
                BundleManifestUtils.createBundleManifest(manifest).write(out);
                System.out.printf("Manifest written to '%s'%n", this.manifestFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void close() {
    }
}

