/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.virgo.ide.runtime.core.IServerWorkingCopy;
import org.eclipse.virgo.ide.runtime.internal.core.actions.ModifyDeployerPortCommand;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class ServerDeployEditorSection
extends ServerEditorSection {
    protected IServerWorkingCopy serverWorkingCopy;
    protected Text port;
    protected Text username;
    protected Text password;
    protected boolean updating;
    protected PropertyChangeListener listener;

    protected void addConfigurationChangeListener() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (ServerDeployEditorSection.this.updating) {
                    return;
                }
                ServerDeployEditorSection.this.updating = true;
                if ("org.eclipse.virgo.ide.runtime.coredeployer.password".equals(event.getPropertyName())) {
                    ServerDeployEditorSection.this.password.setText(event.getNewValue().toString());
                } else if ("org.eclipse.virgo.ide.runtime.coredeployer.port".equals(event.getPropertyName())) {
                    ServerDeployEditorSection.this.port.setText(event.getNewValue().toString());
                } else if ("org.eclipse.virgo.ide.runtime.coredeployer.username".equals(event.getPropertyName())) {
                    ServerDeployEditorSection.this.username.setText(event.getNewValue().toString());
                }
                ServerDeployEditorSection.this.updating = false;
            }
        };
        this.serverWorkingCopy.addConfigurationChangeListener(this.listener);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 458);
        section.setText("Deployer Control");
        section.setDescription("Configure the communication with the server Deployer Control.");
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        GridData data = new GridData(4, 0x1000000, true, false);
        Label portLabel = toolkit.createLabel(composite, "Port:");
        portLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.port = toolkit.createText(composite, "");
        this.port.setLayoutData((Object)data);
        this.port.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ServerDeployEditorSection.this.updating) {
                    return;
                }
                int newPort = -1;
                try {
                    newPort = Integer.valueOf(ServerDeployEditorSection.this.port.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    ServerDeployEditorSection.this.setErrorMessage(String.valueOf(ServerDeployEditorSection.this.port.getText()) + " is not a valid port number");
                    return;
                }
                ServerDeployEditorSection.this.setErrorMessage(null);
                ServerDeployEditorSection.this.updating = true;
                ServerDeployEditorSection.this.execute((IUndoableOperation)new ModifyDeployerPortCommand(ServerDeployEditorSection.this.serverWorkingCopy, newPort));
                ServerDeployEditorSection.this.updating = false;
            }
        });
        this.initialize();
    }

    public void dispose() {
        if (this.server != null) {
            this.server.removePropertyChangeListener(this.listener);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.serverWorkingCopy = (IServerWorkingCopy)this.server.loadAdapter(IServerWorkingCopy.class, (IProgressMonitor)new NullProgressMonitor());
        this.addConfigurationChangeListener();
    }

    protected void initialize() {
        this.updating = true;
        this.port.setText("" + this.serverWorkingCopy.getMBeanServerPort());
        this.updating = false;
    }

    public IStatus[] getSaveStatus() {
        try {
            Integer.valueOf(this.port.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return new IStatus[]{new Status(4, "org.eclipse.virgo.ide.runtime.ui", "'" + this.port.getText() + "' is not a valid port number")};
        }
        return super.getSaveStatus();
    }
}

