/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.bundlor.internal.core.maven;

import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.virgo.bundlor.support.properties.PropertiesSource;

public class MavenPropertiesSource
implements PropertiesSource {
    private static final Properties EMPTY_STANDARD = new Properties();
    private final IProject project;

    public MavenPropertiesSource(IProject project) {
        this.project = project;
    }

    public int getPriority() {
        return 0x7FFFFFFE;
    }

    public Properties getProperties() {
        try {
            IMavenProjectRegistry registry = MavenPlugin.getMavenProjectRegistry();
            IMavenProjectFacade facade = registry.create(this.project, (IProgressMonitor)new NullProgressMonitor());
            if (facade != null) {
                MavenProject mavenProj = facade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
                Properties props = mavenProj.getProperties();
                this.addPropertyIfNotNull(props, "project.artifactId", mavenProj.getArtifactId());
                this.addPropertyIfNotNull(props, "project.groupId", mavenProj.getGroupId());
                this.addPropertyIfNotNull(props, "project.description", mavenProj.getDescription());
                this.addPropertyIfNotNull(props, "project.name", mavenProj.getName());
                this.addPropertyIfNotNull(props, "project.version", mavenProj.getVersion());
                this.addPropertyIfNotNull(props, "pom.artifactId", mavenProj.getArtifactId());
                this.addPropertyIfNotNull(props, "pom.groupId", mavenProj.getGroupId());
                this.addPropertyIfNotNull(props, "pom.description", mavenProj.getDescription());
                this.addPropertyIfNotNull(props, "pom.name", mavenProj.getName());
                this.addPropertyIfNotNull(props, "pom.version", mavenProj.getVersion());
                return props;
            }
        }
        catch (CoreException coreException) {}
        return EMPTY_STANDARD;
    }

    private void addPropertyIfNotNull(Properties props, String key, String value) {
        if (value != null && key != null) {
            props.put(key, value);
        }
    }
}

