/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.ui.editors;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.virgo.ide.facet.core.FacetUtils;
import org.eclipse.virgo.ide.par.Par;
import org.eclipse.virgo.ide.par.provider.ParItemProviderAdapterFactory;
import org.eclipse.virgo.ide.ui.ServerIdeUiPlugin;
import org.eclipse.virgo.ide.ui.StatusHandler;
import org.eclipse.virgo.ide.ui.editors.BundleManifestEditor;
import org.eclipse.virgo.ide.ui.editors.ParOverviewPage;
import org.eclipse.virgo.ide.ui.editors.ParXmlEditorPage;
import org.eclipse.virgo.ide.ui.editors.PdeCompatibilityUtil;
import org.eclipse.virgo.ide.ui.editors.SpringBundleInputContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParManifestEditor
extends BundleManifestEditor {
    public static String ID_EDITOR = "org.eclipse.virgo.ide.ui.parmanifest";
    protected ComposedAdapterFactory adapterFactory;
    protected Viewer currentViewer;
    protected AdapterFactoryEditingDomain editingDomain;
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    private Resource parResource;
    private Par par;
    private IEditorInput parInput;

    public AdapterFactoryEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public Par getPar() {
        return this.par;
    }

    @Override
    protected void addEditorPages() {
        try {
            this.addPage((IFormPage)new ParOverviewPage((FormEditor)this));
            if (this.parInput != null) {
                this.initializeEditingDomain();
                this.createParPages();
            }
        }
        catch (PartInitException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.virgo.ide.ui", "Failed to create editor pages", (Throwable)e));
        }
        this.addSourcePage("bundle-context");
    }

    @Override
    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        IFile file = input.getFile();
        IContainer container = file.getParent();
        IProject project = file.getProject();
        IFile manifestFile = null;
        IFile parFile = null;
        String name = file.getName().toLowerCase(Locale.ENGLISH);
        if (name.equals("manifest.mf")) {
            if (container instanceof IFolder) {
                container = container.getParent();
            }
            manifestFile = file;
            parFile = FacetUtils.getParFile((IProject)project);
        } else if (name.equalsIgnoreCase("org.eclipse.virgo.ide.runtime.core.par.xml")) {
            parFile = file;
            manifestFile = container.getProject().getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        }
        if (manifestFile != null && manifestFile.exists()) {
            FileEditorInput in = new FileEditorInput(manifestFile);
            manager.putContext((IEditorInput)in, (InputContext)new SpringBundleInputContext((PDEFormEditor)this, (IEditorInput)in, file == manifestFile));
        }
        if (parFile != null && parFile.exists()) {
            this.parInput = new FileEditorInput(parFile);
        }
        manager.monitorFile(manifestFile);
        manager.monitorFile(parFile);
        this.fPrefs = new ProjectScope(container.getProject()).getNode("org.eclipse.pde.core");
        if (this.fPrefs != null) {
            this.fShowExtensions = this.fPrefs.getBoolean("pluginProject.extensions", true);
            this.fEquinox = this.fPrefs.getBoolean("pluginProject.equinox", true);
        }
    }

    @Override
    protected void createSystemFileContexts(InputContextManager manager, IEditorInput input) {
        File dir;
        File file = (File)input.getAdapter(File.class);
        if (file == null && input instanceof FileStoreEditorInput) {
            file = new File(((IURIEditorInput)input).getURI());
        }
        if (file == null) {
            return;
        }
        File manifestFile = null;
        File parFile = null;
        String name = file.getName().toLowerCase(Locale.ENGLISH);
        if (name.equals("manifest.mf")) {
            manifestFile = file;
            dir = file.getParentFile().getParentFile();
            parFile = new File(dir, "org.eclipse.virgo.ide.runtime.core.par.xml");
        } else if (name.equals("org.eclipse.virgo.ide.runtime.core.par.xml")) {
            parFile = file;
            dir = file.getParentFile();
            manifestFile = new File(dir.getParentFile(), "META-INF/MANIFEST.MF");
        }
        try {
            if (manifestFile != null && manifestFile.exists()) {
                IEditorInput in = PdeCompatibilityUtil.createSystemFileEditorInput(manifestFile);
                if (in == null) {
                    IFileStore store = EFS.getStore((java.net.URI)manifestFile.toURI());
                    in = new FileStoreEditorInput(store);
                }
                manager.putContext(in, (InputContext)new SpringBundleInputContext((PDEFormEditor)this, in, file == manifestFile));
            }
            if (parFile != null && parFile.exists()) {
                this.parInput = PdeCompatibilityUtil.createSystemFileEditorInput(parFile);
                if (this.parInput == null) {
                    IFileStore store = EFS.getStore((java.net.URI)parFile.toURI());
                    this.parInput = new FileStoreEditorInput(store);
                }
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException((Throwable)e);
        }
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ParItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                ParManifestEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ParManifestEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            ParManifestEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (ParManifestEditor.this.currentViewer != null) {
                        ParManifestEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    public void createModel() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.parInput);
        try {
            this.parResource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            ServerIdeUiPlugin.getDefault().log(e);
            this.parResource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        this.par = (Par)this.parResource.getContents().iterator().next();
    }

    public void createParPages() {
        this.createModel();
        this.addParPages();
    }

    protected void addParPages() {
        try {
            this.addPage((IFormPage)new ParXmlEditorPage(this, "org.eclipse.virgo.ide.ui.editor.par.dependencies", "Dependencies"));
        }
        catch (PartInitException e) {
            ServerIdeUiPlugin.getDefault().log((Exception)((Object)e));
        }
    }

    @Override
    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : ParManifestEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !ParManifestEditor.this.isPersisted(resource) || ParManifestEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        ParManifestEditor.this.savedResources.add(resource);
                        resource.save(saveOptions);
                    }
                    catch (IOException exception) {
                        ParManifestEditor.this.handleError(exception);
                    }
                    first = false;
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            ServerIdeUiPlugin.getDefault().log(exception);
        }
        super.doSave(progressMonitor);
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    private void handleError(IOException exception) {
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
        super.doSaveAs();
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public boolean isDirty() {
        if (this.editingDomain != null && this.editingDomain.getCommandStack() != null) {
            boolean dirty = ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
            return dirty || super.isDirty();
        }
        return super.isDirty();
    }
}

