/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.ShutdownThread;

public class MBeanContainer
extends AbstractLifeCycle
implements Container.Listener,
Dumpable {
    private final MBeanServer _server;
    private final WeakHashMap<Object, ObjectName> _beans = new WeakHashMap();
    private final HashMap<String, Integer> _unique = new HashMap();
    private final MultiMap<ObjectName> _relations = new MultiMap();
    private String _domain = null;

    public synchronized ObjectName findMBean(Object object) {
        ObjectName bean = this._beans.get(object);
        return bean == null ? null : bean;
    }

    public synchronized Object findBean(ObjectName oname) {
        for (Map.Entry<Object, ObjectName> entry : this._beans.entrySet()) {
            ObjectName bean = entry.getValue();
            if (!bean.equals(oname)) continue;
            return entry.getKey();
        }
        return null;
    }

    public MBeanContainer(MBeanServer server) {
        this._server = server;
        try {
            this.start();
        }
        catch (Exception e) {
            Log.ignore((Throwable)e);
        }
    }

    public MBeanServer getMBeanServer() {
        return this._server;
    }

    public void setDomain(String domain) {
        this._domain = domain;
    }

    public String getDomain() {
        return this._domain;
    }

    public synchronized void add(Container.Relationship relationship) {
        ObjectName child;
        ObjectName parent = this._beans.get(relationship.getParent());
        if (parent == null) {
            this.addBean(relationship.getParent());
            parent = this._beans.get(relationship.getParent());
        }
        if ((child = this._beans.get(relationship.getChild())) == null) {
            this.addBean(relationship.getChild());
            child = this._beans.get(relationship.getChild());
        }
        if (parent != null && child != null) {
            this._relations.add((Object)parent, (Object)relationship);
        }
    }

    public synchronized void remove(Container.Relationship relationship) {
        ObjectName parent = this._beans.get(relationship.getParent());
        ObjectName child = this._beans.get(relationship.getChild());
        if (parent != null && child != null) {
            this._relations.removeValue((Object)parent, (Object)relationship);
        }
    }

    public synchronized void removeBean(Object obj) {
        ObjectName bean = this._beans.remove(obj);
        if (bean != null) {
            List beanRelations = this._relations.getValues((Object)bean);
            if (beanRelations != null && beanRelations.size() > 0) {
                Log.debug((String)"Unregister {}", (Object)beanRelations);
                ArrayList removeList = new ArrayList(beanRelations);
                for (Object r : removeList) {
                    Container.Relationship relation = (Container.Relationship)r;
                    relation.getContainer().update(relation.getParent(), relation.getChild(), null, relation.getRelationship(), true);
                }
            }
            try {
                this._server.unregisterMBean(bean);
                Log.debug((String)"Unregistered {}", (Object)bean);
            }
            catch (InstanceNotFoundException e) {
                Log.ignore((Throwable)e);
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
            }
        }
    }

    public synchronized void addBean(Object obj) {
        try {
            if (obj == null || this._beans.containsKey(obj)) {
                return;
            }
            Object mbean = ObjectMBean.mbeanFor(obj);
            if (mbean == null) {
                return;
            }
            ObjectName oname = null;
            if (mbean instanceof ObjectMBean) {
                ((ObjectMBean)mbean).setMBeanContainer(this);
                oname = ((ObjectMBean)mbean).getObjectName();
            }
            if (oname == null) {
                String basis;
                Integer count;
                String type = obj.getClass().getName().toLowerCase();
                int dot = type.lastIndexOf(46);
                if (dot >= 0) {
                    type = type.substring(dot + 1);
                }
                String context = null;
                if (mbean instanceof ObjectMBean) {
                    context = this.makeName(((ObjectMBean)mbean).getObjectContextBasis());
                }
                String name = null;
                if (mbean instanceof ObjectMBean) {
                    name = this.makeName(((ObjectMBean)mbean).getObjectNameBasis());
                }
                StringBuffer buf = new StringBuffer();
                buf.append("type=").append(type);
                if (context != null && context.length() > 1) {
                    buf.append(buf.length() > 0 ? "," : "");
                    buf.append("context=").append(context);
                }
                if (name != null && name.length() > 1) {
                    buf.append(buf.length() > 0 ? "," : "");
                    buf.append("name=").append(name);
                }
                count = (count = this._unique.get(basis = buf.toString())) == null ? 0 : 1 + count;
                this._unique.put(basis, count);
                String domain = this._domain;
                if (domain == null) {
                    domain = obj.getClass().getPackage().getName();
                }
                oname = ObjectName.getInstance(domain + ":" + basis + ",id=" + count);
            }
            ObjectInstance oinstance = this._server.registerMBean(mbean, oname);
            Log.debug((String)"Registered {}", (Object)oinstance.getObjectName());
            this._beans.put(obj, oinstance.getObjectName());
        }
        catch (Exception e) {
            Log.warn((String)("bean: " + obj), (Throwable)e);
        }
    }

    public String makeName(String basis) {
        if (basis == null) {
            return basis;
        }
        return basis.replace(':', '_').replace('*', '_').replace('?', '_').replace('=', '_').replace(',', '_').replace(' ', '_');
    }

    public void doStart() {
        ShutdownThread.register((LifeCycle[])new LifeCycle[]{this});
    }

    public void doStop() {
        HashSet<Object> removeSet = new HashSet<Object>(this._beans.keySet());
        for (Object e : removeSet) {
            this.removeBean(e);
        }
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append(((Object)((Object)this)).toString()).append("\n");
        AggregateLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{this._beans.entrySet()});
    }

    public String dump() {
        return AggregateLifeCycle.dump((Dumpable)this);
    }
}

