/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Date;
import javax.ejb.TimerConfig;
import org.apache.openejb.core.timer.EjbTimerServiceImpl;
import org.apache.openejb.core.timer.TimerData;
import org.apache.openejb.core.timer.TimerType;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class SingleActionTimerData
extends TimerData {
    private final Date expiration;

    public SingleActionTimerData(long id, EjbTimerServiceImpl timerService, String deploymentId, Object primaryKey, Method timeoutMethod, TimerConfig timerConfig, Date expiration) {
        super(id, timerService, deploymentId, primaryKey, timeoutMethod, timerConfig);
        this.expiration = expiration;
    }

    @Override
    public TimerType getType() {
        return TimerType.SingleAction;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    @Override
    public Trigger initializeTrigger() {
        SimpleTrigger simpleTrigger = new SimpleTrigger();
        simpleTrigger.setStartTime(this.expiration);
        return simpleTrigger;
    }

    public String toString() {
        return TimerType.SingleAction.name() + " expiration = [" + DateFormat.getDateTimeInstance().format(this.expiration) + "]";
    }
}

