/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.ejb.Stateful;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.cdi.CdiEjbBean;
import org.apache.openejb.cdi.CdiResourceInjectionService;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.portable.events.discovery.BeforeShutdownImpl;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.SecurityService;
import org.apache.webbeans.spi.TransactionService;
import org.apache.webbeans.spi.plugins.AbstractOwbPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansJavaEEPlugin;
import org.apache.webbeans.util.WebBeansUtil;

public class CdiPlugin
extends AbstractOwbPlugin
implements OpenWebBeansJavaEEPlugin,
OpenWebBeansEjbPlugin {
    private AppContext appContext;
    private Set<Class<?>> beans;
    private WebBeansContext webBeansContext;
    private CdiAppContextsService contexsServices;

    public void shutDown() {
        super.shutDown();
        if (this.beans != null) {
            this.beans.clear();
        }
    }

    public void setAppContext(AppContext appContext) {
        this.appContext = appContext;
    }

    public void configureDeployments(List<BeanContext> ejbDeployments) {
        WeakHashMap beans = new WeakHashMap();
        for (BeanContext deployment : ejbDeployments) {
            if (!deployment.getComponentType().isSession()) continue;
            beans.put(deployment.getBeanClass(), null);
        }
        this.beans = beans.keySet();
    }

    public CdiAppContextsService getContexsServices() {
        return this.contexsServices;
    }

    public void startup() {
        this.webBeansContext = this.appContext.getWebBeansContext();
        this.contexsServices = (CdiAppContextsService)this.webBeansContext.getContextsService();
        this.contexsServices.init(null);
    }

    public void stop() throws OpenEJBException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.appContext.getClassLoader());
            this.appContext.getBeanManager().fireEvent((Object)new BeforeShutdownImpl(), new Annotation[0]);
            this.contexsServices.destroy(null);
            this.webBeansContext.getPluginLoader().shutDown();
            this.webBeansContext.getExtensionLoader().clear();
            InjectionResolver.getInstance().clearCaches();
            this.webBeansContext.getJavassistProxyFactory().clear();
            this.webBeansContext.getAnnotatedElementFactory().clear();
            this.webBeansContext.getjMSManager().clear();
            CdiResourceInjectionService injectionServices = (CdiResourceInjectionService)this.webBeansContext.getService(ResourceInjectionService.class);
            injectionServices.clear();
            WebBeansFinder.clearInstances((Object)WebBeansUtil.getCurrentClassLoader());
        }
        catch (Exception e) {
            throw new OpenEJBException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public <T> T getSupportedService(Class<T> serviceClass) {
        return this.supportService(serviceClass) ? (T)serviceClass.cast((Object)this) : null;
    }

    public void isManagedBean(Class<?> clazz) {
    }

    public boolean supportService(Class<?> serviceClass) {
        return serviceClass == TransactionService.class || serviceClass == SecurityService.class;
    }

    public Object getSessionBeanProxy(Bean<?> bean, Class<?> interfce, CreationalContext<?> creationalContext) {
        Context context = this.webBeansContext.getBeanManagerImpl().getContext(bean.getScope());
        CreationalContext<?> cc = creationalContext;
        Bean<?> component = bean;
        return context.get(component, cc);
    }

    public boolean isSessionBean(Class<?> clazz) {
        return this.beans != null && this.beans.contains(clazz);
    }

    public <T> Bean<T> defineSessionBean(Class<T> clazz, ProcessAnnotatedType<T> processAnnotateTypeEvent) {
        throw new IllegalStateException("Statement should never be reached");
    }

    public boolean isSingletonBean(Class<?> clazz) {
        throw new IllegalStateException("Statement should never be reached");
    }

    public boolean isStatefulBean(Class<?> clazz) {
        return clazz.isAnnotationPresent(Stateful.class);
    }

    public boolean isStatelessBean(Class<?> clazz) {
        throw new IllegalStateException("Statement should never be reached");
    }

    public Method resolveViewMethod(Bean<?> component, Method declaredMethod) {
        if (!(component instanceof CdiEjbBean)) {
            return declaredMethod;
        }
        CdiEjbBean cdiEjbBean = (CdiEjbBean)component;
        BeanContext beanContext = cdiEjbBean.getBeanContext();
        for (Class intface : beanContext.getBusinessLocalInterfaces()) {
            try {
                return intface.getMethod(declaredMethod.getName(), declaredMethod.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
            }
        }
        return declaredMethod;
    }

    public Method resolveBeanMethod(Bean<?> component, Method declaredMethod) {
        if (!(component instanceof CdiEjbBean)) {
            return declaredMethod;
        }
        CdiEjbBean cdiEjbBean = (CdiEjbBean)component;
        BeanContext beanContext = cdiEjbBean.getBeanContext();
        try {
            return beanContext.getBeanClass().getMethod(declaredMethod.getName(), declaredMethod.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return declaredMethod;
        }
    }
}

