/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.wsi.internal.WSITestToolsProperties;
import org.eclipse.wst.wsi.internal.core.profile.validator.BaseValidator;

public class WSITestToolsPlugin
extends Plugin {
    private static Plugin instance;
    protected final String PLUGIN_PROPERTIES = "wsivalidate";
    protected static final String PLUGIN_ID = "org.eclipse.wst.wsi";
    protected static final String VALIDATOR_EXT_ID = "org.eclipse.wst.wsi.wsivalidator";
    protected static final String TAD_VERSION_EXT_ID = "org.eclipse.wst.wsi.tads";
    protected static final String REPORT_ARTIFACT_TYPES_EXT_ID = "org.eclipse.wst.wsi.reportArtifactTypes";
    protected static final String ATT_CLASS = "class";
    protected static final String ATT_TAD_NAME = "name";
    protected static final String ATT_TAD_VERSION = "version";
    protected static final String ATT_ARTIFACT_TYPE = "artifactType";
    private BaseValidator[] validators;
    private String[][] tadVersions;
    private String[] reportArtifactTypes;

    public WSITestToolsPlugin() {
        instance = this;
        WSITestToolsProperties.setEclipseContext(true);
    }

    public static Plugin getInstance() {
        return instance;
    }

    public static WSITestToolsPlugin getPlugin() {
        return (WSITestToolsPlugin)instance;
    }

    private BaseValidator[] computeValidators() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(VALIDATOR_EXT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        ArrayList<BaseValidator> results = new ArrayList<BaseValidator>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement validatorElement = extensions[i].getConfigurationElements()[0];
            BaseValidator validator = null;
            try {
                validator = (BaseValidator)validatorElement.createExecutableExtension(ATT_CLASS);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            results.add(validator);
            ++i;
        }
        return results.toArray(new BaseValidator[0]);
    }

    public BaseValidator[] getBaseValidators() {
        if (this.validators == null) {
            this.validators = this.computeValidators();
        }
        return this.validators;
    }

    public String[] getArtifactTypes() {
        if (this.validators == null) {
            this.getBaseValidators();
        }
        String[] artifactTypes = new String[this.validators.length];
        int i = 0;
        while (i < this.validators.length) {
            artifactTypes[i] = this.validators[i].getArtifactType();
            ++i;
        }
        return artifactTypes;
    }

    private String[][] computeTADVersions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(TAD_VERSION_EXT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        ArrayList<String[]> results = new ArrayList<String[]>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] versionElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < versionElements.length) {
                String[] nameVersion = new String[]{versionElements[j].getAttribute(ATT_TAD_NAME), versionElements[j].getAttribute(ATT_TAD_VERSION)};
                results.add(nameVersion);
                ++j;
            }
            ++i;
        }
        return (String[][])results.toArray((T[])new String[0][0]);
    }

    public String[][] getAllTADVersions() {
        if (this.tadVersions == null) {
            this.tadVersions = this.computeTADVersions();
        }
        return this.tadVersions;
    }

    private String[] computeReportArtifactTypes() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(REPORT_ARTIFACT_TYPES_EXT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] reportArtifactElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < reportArtifactElements.length) {
                String reportArtifact = reportArtifactElements[j].getAttribute(ATT_ARTIFACT_TYPE);
                results.add(reportArtifact);
                ++j;
            }
            ++i;
        }
        return results.toArray(new String[0]);
    }

    public String[] getAllReportArtifactTypes() {
        if (this.reportArtifactTypes == null) {
            this.reportArtifactTypes = this.computeReportArtifactTypes();
        }
        return this.reportArtifactTypes;
    }
}

