/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.comparator;

import java.text.Collator;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.comparator.ComparatorAdapter;
import org.eclipse.jpt.common.utility.internal.comparator.ComparatorTools;

public class ComparatorToolsTests
extends TestCase {
    public ComparatorToolsTests(String name) {
        super(name);
    }

    public void testMinObjectObject() {
        String foo = "foo";
        String bar = "bar";
        ComparatorToolsTests.assertEquals((String)bar, (String)((String)((Object)ComparatorTools.min((Comparable)((Object)foo), (Comparable)((Object)bar)))));
        ComparatorToolsTests.assertEquals((String)bar, (String)((String)((Object)ComparatorTools.min((Comparable)((Object)bar), (Comparable)((Object)foo)))));
    }

    public void testMinObjectObjectComparator() {
        String foo = "foo";
        String bar = "bar";
        ComparatorToolsTests.assertEquals((String)foo, (String)((String)ComparatorTools.min((Object)foo, (Object)bar, (Comparator)ComparatorTools.reverseComparator())));
        ComparatorToolsTests.assertEquals((String)foo, (String)((String)ComparatorTools.min((Object)bar, (Object)foo, (Comparator)ComparatorTools.reverseComparator())));
    }

    public void testMaxObjectObject() {
        String foo = "foo";
        String bar = "bar";
        ComparatorToolsTests.assertEquals((String)foo, (String)((String)((Object)ComparatorTools.max((Comparable)((Object)foo), (Comparable)((Object)bar)))));
        ComparatorToolsTests.assertEquals((String)foo, (String)((String)((Object)ComparatorTools.max((Comparable)((Object)bar), (Comparable)((Object)foo)))));
    }

    public void testMaxObjectObjectComparator() {
        String foo = "foo";
        String bar = "bar";
        ComparatorToolsTests.assertEquals((String)bar, (String)((String)ComparatorTools.max((Object)foo, (Object)bar, (Comparator)ComparatorTools.reverseComparator())));
        ComparatorToolsTests.assertEquals((String)bar, (String)((String)ComparatorTools.max((Object)bar, (Object)foo, (Comparator)ComparatorTools.reverseComparator())));
    }

    public void testComparableComparator() {
        ComparatorToolsTests.assertTrue((ComparatorTools.comparableComparator().compare("foo", "foo") == 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.comparableComparator().compare("foo", "bar") > 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.comparableComparator().compare("bar", "foo") < 0 ? 1 : 0) != 0);
    }

    public void testNaturalComparator() {
        ComparatorToolsTests.assertTrue((ComparatorTools.naturalComparator().compare("foo", "foo") == 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.naturalComparator().compare("foo", "bar") > 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.naturalComparator().compare("bar", "foo") < 0 ? 1 : 0) != 0);
    }

    public void testComparatorChain() throws Exception {
        Comparator comparator = ComparatorTools.chain((Comparator[])new Comparator[]{Person.LAST_NAME_COMPARATOR, Person.FIRST_NAME_COMPARATOR, Person.BIRTH_DATE_COMPARATOR});
        Person john = new Person("John", "Smith", DateFormat.getDateInstance(3).parse("10/11/1955"));
        Person jane = new Person("Jane", "Smith", DateFormat.getDateInstance(3).parse("10/11/1955"));
        ComparatorToolsTests.assertTrue((comparator.compare(john, john) == 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((comparator.compare(jane, john) < 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((comparator.compare(john, jane) > 0 ? 1 : 0) != 0);
        Person oldJohn = new Person("John", "Smith", DateFormat.getDateInstance(3).parse("10/11/1933"));
        ComparatorToolsTests.assertTrue((comparator.compare(oldJohn, oldJohn) == 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((comparator.compare(oldJohn, john) < 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((comparator.compare(john, oldJohn) > 0 ? 1 : 0) != 0);
    }

    public void testNullsFirstComparator() {
        ComparatorToolsTests.assertTrue((ComparatorTools.nullsFirst((Comparator)ComparatorTools.stringCollator()).compare("foo", "foo") == 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.nullsFirst((Comparator)ComparatorTools.stringCollator()).compare("foo", "bar") > 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.nullsFirst((Comparator)ComparatorTools.stringCollator()).compare("bar", "foo") < 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.nullsFirst((Comparator)ComparatorTools.stringCollator()).compare(null, null) == 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.nullsFirst((Comparator)ComparatorTools.stringCollator()).compare("foo", null) > 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.nullsFirst((Comparator)ComparatorTools.stringCollator()).compare(null, "foo") < 0 ? 1 : 0) != 0);
    }

    public void testNullsLastComparator() {
        ComparatorToolsTests.assertTrue((ComparatorTools.nullsLast((Comparator)ComparatorTools.stringCollator()).compare("foo", "foo") == 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.nullsLast((Comparator)ComparatorTools.stringCollator()).compare("foo", "bar") > 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.nullsLast((Comparator)ComparatorTools.stringCollator()).compare("bar", "foo") < 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.nullsLast((Comparator)ComparatorTools.stringCollator()).compare(null, null) == 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.nullsLast((Comparator)ComparatorTools.stringCollator()).compare("foo", null) < 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.nullsLast((Comparator)ComparatorTools.stringCollator()).compare(null, "foo") > 0 ? 1 : 0) != 0);
    }

    public void testTransformationComparator() {
        ComparatorToolsTests.assertTrue((ComparatorTools.nullsLast((Comparator)ComparatorTools.stringCollator()).compare("foo", "foo") == 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.nullsLast((Comparator)ComparatorTools.stringCollator()).compare("foo", "bar") > 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.nullsLast((Comparator)ComparatorTools.stringCollator()).compare("bar", "foo") < 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.nullsLast((Comparator)ComparatorTools.stringCollator()).compare(null, null) == 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.nullsLast((Comparator)ComparatorTools.stringCollator()).compare("foo", null) < 0 ? 1 : 0) != 0);
        ComparatorToolsTests.assertTrue((ComparatorTools.nullsLast((Comparator)ComparatorTools.stringCollator()).compare(null, "foo") > 0 ? 1 : 0) != 0);
    }

    public static class Person {
        public final String firstName;
        public final String lastName;
        public final Date birthDate;
        public static final Comparator<Person> FIRST_NAME_COMPARATOR = new FirstNameComparator();
        public static final Comparator<Person> LAST_NAME_COMPARATOR = new LastNameComparator();
        public static final Comparator<Person> BIRTH_DATE_COMPARATOR = new BirthDateComparator();

        public Person(String firstName, String lastName, Date birthDate) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.birthDate = birthDate;
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (CharSequence)(String.valueOf(this.firstName) + ' ' + this.lastName));
        }

        public static class BirthDateComparator
        extends ComparatorAdapter<Person> {
            public int compare(Person p1, Person p2) {
                return p1.birthDate.compareTo(p2.birthDate);
            }
        }

        public static class FirstNameComparator
        extends ComparatorAdapter<Person> {
            public int compare(Person p1, Person p2) {
                return Collator.getInstance().compare(p1.firstName, p2.firstName);
            }
        }

        public static class LastNameComparator
        extends ComparatorAdapter<Person> {
            public int compare(Person p1, Person p2) {
                return Collator.getInstance().compare(p1.lastName, p2.lastName);
            }
        }
    }
}

