/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentExtensionType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.DynamicAttribute;
import org.eclipse.jst.jsf.facesconfig.emf.DynamicElement;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadExtensionDataTestCase
extends BaseReadTestCase {
    public ReadExtensionDataTestCase(String name) {
        super(name);
    }

    public void testSingleElementRoot() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead((IProject)this.project, (String)"WEB-INF/faces-config-ext-data1.xml");
            ReadExtensionDataTestCase.assertNotNull((Object)edit.getFacesConfig());
            ComponentType component1 = this.getComponent1(edit.getFacesConfig());
            ReadExtensionDataTestCase.assertNotNull((Object)component1);
            ComponentExtensionType extType = (ComponentExtensionType)FacesConfigModelUtil.findEObjectElementById((List)component1.getComponentExtension(), "singleRootComponentExt");
            ReadExtensionDataTestCase.assertNotNull((Object)extType);
            EList elements = extType.getChildNodes();
            ReadExtensionDataTestCase.assertEquals((int)1, (int)elements.size());
            DynamicElement singleRoot = (DynamicElement)elements.get(0);
            ReadExtensionDataTestCase.assertEquals((String)"any-data", (String)singleRoot.getName());
            ReadExtensionDataTestCase.assertEquals((int)1, (int)singleRoot.getAttributes().size());
            DynamicAttribute attribute = (DynamicAttribute)singleRoot.getAttributes().get(0);
            ReadExtensionDataTestCase.assertEquals((String)"attribute", (String)attribute.getName());
            ReadExtensionDataTestCase.assertEquals((String)"any-data-attribute", (String)attribute.getValue());
            ReadExtensionDataTestCase.assertEquals((int)2, (int)singleRoot.getChildNodes().size());
            DynamicElement firstChild = (DynamicElement)singleRoot.getChildNodes().get(0);
            ReadExtensionDataTestCase.assertEquals((String)"first-child", (String)firstChild.getName());
            ReadExtensionDataTestCase.assertEquals((String)"someData", (String)firstChild.getTextContent());
            DynamicElement secondChild = (DynamicElement)singleRoot.getChildNodes().get(1);
            ReadExtensionDataTestCase.assertEquals((String)"second-child", (String)secondChild.getName());
            ReadExtensionDataTestCase.assertEquals((String)"second Child's data", (String)secondChild.getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private ComponentType getComponent1(FacesConfigType facesConfig) {
        return (ComponentType)FacesConfigModelUtil.findEObjectElementById((List)facesConfig.getComponent(), "component1");
    }
}

