/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.java.IJSPTranslation;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationAdapter;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslator;
import org.eclipse.jst.jsp.core.internal.modelhandler.ModelHandlerForJSP;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.FileBufferModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JSPTranslatorPersister {
    public static final boolean ACTIVATED = Boolean.valueOf(System.getProperty("persistJSPTranslations", "true"));
    private static final IPath PERSIST_LOCATION = JSPCorePlugin.getDefault().getStateLocation().append("translators");
    private static final CRC32 CHECKSUM_CALC = new CRC32();
    private static final Object CHECKSUM_CALC_LOCK = new Object();

    private JSPTranslatorPersister() {
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JSPTranslator getPersistedTranslator(IStructuredModel model) {
        String persistedTranslatorFilePath = JSPTranslatorPersister.getPersistedTranslatorFilePath(model.getBaseLocation());
        File persistedTranslatorFile = new File(persistedTranslatorFilePath);
        JSPTranslator translator = null;
        ObjectInputStream in = null;
        try {
            try {
                long jspFileTimestamp;
                if (!persistedTranslatorFile.exists()) return translator;
                long persistedTranslatorFileTimestamp = persistedTranslatorFile.lastModified();
                if (persistedTranslatorFileTimestamp > (jspFileTimestamp = FileBufferModelManager.getInstance().getBuffer((IDocument)model.getStructuredDocument()).getModificationStamp())) {
                    FileInputStream fis = new FileInputStream(persistedTranslatorFile);
                    in = new ObjectInputStream(fis);
                    translator = (JSPTranslator)in.readObject();
                    if (translator == null) return translator;
                    translator.postReadExternalSetup(model);
                    return translator;
                } else {
                    persistedTranslatorFile.delete();
                }
                return translator;
            }
            catch (InvalidClassException invalidClassException) {
                persistedTranslatorFile.delete();
                if (in == null) return translator;
                try {
                    in.close();
                    return translator;
                }
                catch (IOException e) {
                    Logger.logException("Could not close externalized JSPTranslator that was just read", e);
                }
                return translator;
            }
            catch (IOException e) {
                Logger.logException("Could not read externalized JSPTranslator at " + persistedTranslatorFilePath, e);
                if (in == null) return translator;
                try {
                    in.close();
                    return translator;
                }
                catch (IOException e2) {
                    Logger.logException("Could not close externalized JSPTranslator that was just read", e2);
                }
                return translator;
            }
            catch (ClassNotFoundException e) {
                Logger.logException("Class of a serialized JSPTranslator cannot be found", e);
                if (in == null) return translator;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    in.close();
                    return translator;
                }
                catch (IOException e3) {
                    Logger.logException("Could not close externalized JSPTranslator that was just read", e3);
                }
                return translator;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    Logger.logException("Could not close externalized JSPTranslator that was just read", e);
                }
            }
        }
    }

    public static void persistTranslation(IResource resource) {
        if (ACTIVATED) {
            IPath path = resource.getFullPath();
            String filePath = JSPTranslatorPersister.getPersistedTranslatorFilePath(path.toString());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            JSPTranslator translator = JSPTranslatorPersister.getJSPTranslator(file);
            if (translator != null) {
                JSPTranslatorPersister.persistTranslator(translator, filePath);
            }
        }
    }

    public static void removePersistedTranslation(IResource resource) {
        if (ACTIVATED) {
            File file = JSPTranslatorPersister.getPersistedFile(resource.getFullPath());
            file.delete();
        }
    }

    public static void movePersistedTranslation(IResource resource, IPath fromPath) {
        if (ACTIVATED) {
            File from = JSPTranslatorPersister.getPersistedFile(fromPath);
            File to = JSPTranslatorPersister.getPersistedFile(resource.getFullPath());
            from.renameTo(to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPersistedTranslatorFilePath(String jspFilePath) {
        String persistedTranslatorFileName = "error.translator";
        Object object = CHECKSUM_CALC_LOCK;
        synchronized (object) {
            try {
                CHECKSUM_CALC.reset();
                CHECKSUM_CALC.update(jspFilePath.getBytes("utf16"));
                persistedTranslatorFileName = String.valueOf(Long.toString(CHECKSUM_CALC.getValue())) + ".translator";
            }
            catch (UnsupportedEncodingException e) {
                Logger.logException("Could not get utf16 encoded bytes to create checksum to store persisted file.", e);
            }
        }
        IPath location = PERSIST_LOCATION;
        File folder = new File(location.toOSString());
        if (!folder.isDirectory()) {
            try {
                folder.mkdir();
            }
            catch (SecurityException securityException) {}
        }
        location = location.addTrailingSeparator();
        location = location.append(persistedTranslatorFileName);
        return location.toOSString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JSPTranslator getJSPTranslator(IFile jspFile) {
        IStructuredModel model = null;
        JSPTranslator translator = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(jspFile);
                if (!(model instanceof IDOMModel)) return translator;
                IDOMDocument doc = ((IDOMModel)model).getDocument();
                ModelHandlerForJSP.ensureTranslationAdapterFactory(model);
                JSPTranslationAdapter adapter = (JSPTranslationAdapter)doc.getAdapterFor(IJSPTranslation.class);
                if (adapter == null || !adapter.hasTranslation()) return translator;
                translator = adapter.getJSPTranslation().getTranslator();
                return translator;
            }
            catch (IOException e) {
                Logger.logException("Could not get translator for " + jspFile.getName() + " because could not read model for same.", e);
                if (model == null) return translator;
                model.releaseFromRead();
                return translator;
            }
            catch (CoreException e) {
                Logger.logException("Could not get translator for " + jspFile.getName() + " because could not read model for same.", e);
                if (model == null) return translator;
                model.releaseFromRead();
                return translator;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private static void persistTranslator(JSPTranslator translator, String filePath) {
        try {
            FileOutputStream fos = new FileOutputStream(filePath);
            ObjectOutputStream out = new ObjectOutputStream(fos);
            out.writeObject(translator);
            out.close();
        }
        catch (IOException e) {
            Logger.logException("Was unable to externalize JSPTranslator " + translator + " to " + filePath, e);
        }
    }

    private static File getPersistedFile(IPath path) {
        return new File(JSPTranslatorPersister.getPersistedTranslatorFilePath(path.toString()));
    }
}

