/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.parser;

import org.eclipse.wst.html.core.tests.parser.ModelTest;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementTest
extends ModelTest {
    public ElementTest(String name) {
        super(name);
    }

    public ElementTest() {
    }

    public Element changeTagName(Element element, String tagName) {
        Document document = element.getOwnerDocument();
        Node parent = element.getParentNode();
        Element newElement = document.createElement(tagName);
        NamedNodeMap attributes = element.getAttributes();
        while (attributes.getLength() > 0) {
            Attr attr = (Attr)attributes.item(0);
            attr = element.removeAttributeNode(attr);
            newElement.setAttributeNode(attr);
        }
        while (element.hasChildNodes()) {
            Node child = element.getFirstChild();
            child = element.removeChild(child);
            newElement.appendChild(child);
        }
        parent.insertBefore(newElement, element);
        parent.removeChild(element);
        return newElement;
    }

    public static void main(String[] args) {
        new ElementTest().testModel();
    }

    @Override
    public void testModel() {
        IDOMModel model = ElementTest.createXMLModel();
        try {
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            IDOMDocument document = model.getDocument();
            structuredDocument.replaceText(null, 0, 0, "<a><b e=\"f\" c=\"d\"><g /><h /></b></a>");
            Node a = document.getFirstChild();
            Element b = (Element)a.getFirstChild();
            this.printSource(model);
            this.printTree(model);
            this.changeTagName(b, "i");
            this.printSource(model);
            this.printTree(model);
            this.saveAndCompareTestResults();
        }
        finally {
            model.releaseFromEdit();
        }
    }
}

