/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.tests.internal.platforms;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.PropertySetImpl;
import org.eclipse.datatools.connectivity.drivers.XMLFileManager;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObjectListener;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.io.WriterTools;
import org.eclipse.jpt.common.utility.internal.jdbc.ConnectionTools;
import org.eclipse.jpt.common.utility.internal.jdbc.ResultSetTools;
import org.eclipse.jpt.common.utility.io.IndentingPrintWriter;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ConnectionListener;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.ConnectionProfileAdapter;
import org.eclipse.jpt.jpa.db.ConnectionProfileFactory;
import org.eclipse.jpt.jpa.db.ConnectionProfileListener;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.DatabaseIdentifierAdapter;
import org.eclipse.jpt.jpa.db.DatabaseObject;
import org.eclipse.jpt.jpa.db.ForeignKey;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jpt.jpa.db.Sequence;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.db.tests.internal.plugin.JptJpaDbTestsPlugin;

public abstract class DTPPlatformTests
extends TestCase {
    private Properties platformProperties;
    protected ConnectionProfile connectionProfile;
    private static final String PLATFORM_CONFIG_DIRECTORY = "config";
    private static final String DB_USER_ID_PROPERTY = "userID";
    private static final String DB_USER_ID_DEFAULT = "user";
    private static final String DB_PASSWORD_PROPERTY = "password";
    private static final String DB_PASSWORD_DEFAULT = "";
    private static final String DB_DRIVER_JARS_PROPERTY = "jars";
    private static final String DB_URL_PROPERTY = "url";

    protected DTPPlatformTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.platformProperties = this.loadPlatformProperties();
        this.buildDTPDriverDefinitionFile();
        this.buildDTPConnectionProfile();
        this.connectionProfile = this.getConnectionProfileFactory().buildConnectionProfile(this.getProfileName(), DatabaseIdentifierAdapter.Default.instance());
    }

    protected void tearDown() throws Exception {
        this.connectionProfile = null;
        this.platformProperties = null;
        this.checkForListenerLeak();
        super.tearDown();
    }

    protected void checkForListenerLeak() {
        for (Map.Entry<ICatalogObject, Vector<ICatalogObjectListener>> entry : this.getDTPRefreshListeners().entrySet()) {
            this.checkForListenerLeak(entry.getValue());
        }
        this.checkForListenerLeak(this.getDTPGlobalRefreshListeners());
    }

    protected void checkForListenerLeak(Vector<ICatalogObjectListener> listeners) {
        String pkg = DatabaseObject.class.getPackage().getName();
        for (ICatalogObjectListener listener : listeners) {
            if (!listener.getClass().getName().startsWith(pkg)) continue;
            DTPPlatformTests.fail((String)("listener leak: " + listener));
        }
    }

    protected Hashtable<ICatalogObject, Vector<ICatalogObjectListener>> getDTPRefreshListeners() {
        return (Hashtable)ObjectTools.get((Object)RefreshManager.getInstance(), (String)"listeners");
    }

    protected Vector<ICatalogObjectListener> getDTPGlobalRefreshListeners() {
        return (Vector)ObjectTools.get((Object)RefreshManager.getInstance(), (String)"globalListeners");
    }

    private Properties loadPlatformProperties() throws IOException {
        Properties p = new Properties();
        p.load(this.buildPlatformPropertiesFileURL().openStream());
        return p;
    }

    private URL buildPlatformPropertiesFileURL() {
        return JptJpaDbTestsPlugin.instance().getBundle().getEntry(this.getPlatformPropertiesFilePath());
    }

    private String getPlatformPropertiesFilePath() {
        return String.valueOf(this.getPlatformPropertiesDirectoryName()) + '/' + this.getPlatformPropertiesFileName();
    }

    private String getPlatformPropertiesDirectoryName() {
        return PLATFORM_CONFIG_DIRECTORY;
    }

    protected abstract String getPlatformPropertiesFileName();

    private void buildDTPDriverDefinitionFile() throws CoreException {
        IPropertySet[] sets;
        XMLFileManager.setStorageLocation((IPath)this.getDTPDriverDefinitionLocation());
        XMLFileManager.setFileName((String)this.getDTPDriverFileName());
        IPropertySet[] iPropertySetArray = sets = XMLFileManager.loadPropertySets();
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertySet set = iPropertySetArray[n2];
            if (set.getID().equals(this.getDriverDefinitionID())) {
                return;
            }
            ++n2;
        }
        XMLFileManager.saveNamedPropertySet((IPropertySet[])this.buildDTPDriverDefinitionPropertySets());
        File driverDefinitioneFile = this.getDTPDriverDefinitionLocation().append(this.getDTPDriverFileName()).toFile();
        DTPPlatformTests.assertTrue((boolean)driverDefinitioneFile.exists());
    }

    private IPath getDTPDriverDefinitionLocation() {
        return ConnectivityPlugin.getDefault().getStateLocation();
    }

    private String getDTPDriverFileName() {
        return "driverStorage.xml";
    }

    private IPropertySet[] buildDTPDriverDefinitionPropertySets() {
        IPropertySet[] propertySets = new IPropertySet[1];
        PropertySetImpl propertySet = new PropertySetImpl(this.getDriverName(), this.getDriverDefinitionID());
        propertySet.setProperties(this.getDriverDefinitionID(), this.buildDTPDriverDefinitionProperties());
        propertySets[0] = propertySet;
        return propertySets;
    }

    protected abstract String getDriverName();

    protected abstract String getDriverDefinitionID();

    private Properties buildDTPDriverDefinitionProperties() {
        Properties p = new Properties();
        p.setProperty("org.eclipse.datatools.connectivity.drivers.defnType", this.getDriverDefinitionType());
        p.setProperty("jarList", this.getJDBCDriverJarList());
        p.setProperty("org.eclipse.datatools.connectivity.db.vendor", this.getDatabaseVendor());
        p.setProperty("org.eclipse.datatools.connectivity.db.version", this.getDatabaseVersion());
        p.setProperty("org.eclipse.datatools.connectivity.db.driverClass", this.getDriverClass());
        p.setProperty("org.eclipse.datatools.connectivity.db.URL", this.getJDBCURL());
        p.setProperty("org.eclipse.datatools.connectivity.db.username", this.getUserID());
        p.setProperty("org.eclipse.datatools.connectivity.db.password", this.getPassword());
        return p;
    }

    protected abstract String getDriverDefinitionType();

    private String getJDBCDriverJarList() {
        return this.getRequiredPlatformProperty(DB_DRIVER_JARS_PROPERTY);
    }

    protected abstract String getDatabaseVendor();

    protected abstract String getDatabaseVersion();

    protected abstract String getDriverClass();

    private String getJDBCURL() {
        return this.platformProperties.getProperty(DB_URL_PROPERTY, this.getDefaultJDBCURL());
    }

    protected String getDefaultJDBCURL() {
        return DB_PASSWORD_DEFAULT;
    }

    protected String getUserID() {
        return this.platformProperties.getProperty(DB_USER_ID_PROPERTY, DB_USER_ID_DEFAULT);
    }

    private String getPassword() {
        return this.platformProperties.getProperty(DB_PASSWORD_PROPERTY, DB_PASSWORD_DEFAULT);
    }

    private void buildDTPConnectionProfile() throws ConnectionProfileException {
        if (this.getDTPProfileManager().getProfileByName(this.getProfileName()) != null) {
            return;
        }
        this.createProfile(this.getProfileName());
        DTPPlatformTests.assertNotNull((Object)this.getDTPProfileManager().getProfileByName(this.getProfileName()));
    }

    protected void createProfile(String profileName) throws ConnectionProfileException {
        this.getDTPProfileManager().createProfile(profileName, this.getProfileDescription(), this.getProviderID(), this.buildDTPConnectionProfileProperties());
    }

    protected abstract String getProfileName();

    protected abstract String getProfileDescription();

    protected String getProviderID() {
        return "org.eclipse.datatools.connectivity.db.generic.connectionProfile";
    }

    protected Properties buildDTPConnectionProfileProperties() {
        Properties p = new Properties();
        p.setProperty("org.eclipse.datatools.connectivity.db.username", this.getUserID());
        p.setProperty("org.eclipse.datatools.connectivity.db.password", this.getPassword());
        p.setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", this.getDriverDefinitionID());
        p.setProperty("org.eclipse.datatools.connectivity.db.driverClass", this.getDriverClass());
        p.setProperty("org.eclipse.datatools.connectivity.db.URL", this.getJDBCURL());
        p.setProperty("org.eclipse.datatools.connectivity.db.vendor", this.getDatabaseVendor());
        p.setProperty("org.eclipse.datatools.connectivity.db.version", this.getDatabaseVersion());
        p.setProperty("org.eclipse.datatools.connectivity.db.savePWD", this.passwordIsSaved());
        return p;
    }

    private String passwordIsSaved() {
        return "true";
    }

    public void testConnectionProfileListener() throws ConnectionProfileException {
        TestConnectionProfileListener listener = new TestConnectionProfileListener();
        this.getConnectionProfileFactory().addConnectionProfileListener((ConnectionProfileListener)listener);
        String cpName1 = String.valueOf(this.getProfileName()) + "1";
        this.createProfile(cpName1);
        IConnectionProfile dtpCP = this.getDTPProfileManager().getProfileByName(cpName1);
        DTPPlatformTests.assertNotNull((Object)dtpCP);
        DTPPlatformTests.assertEquals((String)cpName1, (String)listener.addedName);
        listener.clear();
        String cpName2 = String.valueOf(this.getProfileName()) + "2";
        this.getDTPProfileManager().modifyProfile(dtpCP, cpName2, null);
        DTPPlatformTests.assertEquals((String)cpName1, (String)listener.renamedOldName);
        DTPPlatformTests.assertEquals((String)cpName2, (String)listener.renamedNewName);
        listener.clear();
        ConnectionProfile cp = this.getConnectionProfileFactory().buildConnectionProfile(cpName2);
        DTPPlatformTests.assertNotNull((Object)cp);
        this.getDTPProfileManager().deleteProfile(dtpCP);
        DTPPlatformTests.assertEquals((String)cpName2, (String)listener.removedName);
        listener.clear();
        cp = this.getConnectionProfileFactory().buildConnectionProfile(cpName2);
        DTPPlatformTests.assertNull((Object)cp);
        this.getConnectionProfileFactory().removeConnectionProfileListener((ConnectionProfileListener)listener);
    }

    public void testName() {
        DTPPlatformTests.assertEquals((String)this.getProfileName(), (String)this.connectionProfile.getName());
    }

    public void testConnection() throws Exception {
        DTPPlatformTests.assertTrue((boolean)this.connectionProfile.isInactive());
        DTPPlatformTests.assertTrue((boolean)this.connectionProfile.isDisconnected());
        this.connectionProfile.connect();
        DTPPlatformTests.assertTrue((boolean)this.connectionProfile.isActive());
        DTPPlatformTests.assertTrue((boolean)this.connectionProfile.isConnected());
        this.verifyDatabaseVersionNumber();
        this.verifyDatabaseVendor();
        this.verifyDatabaseContent();
        this.connectionProfile.disconnect();
        DTPPlatformTests.assertTrue((boolean)this.connectionProfile.isInactive());
        DTPPlatformTests.assertTrue((boolean)this.connectionProfile.isDisconnected());
    }

    private void verifyDatabaseVersionNumber() {
        Database database = this.connectionProfile.getDatabase();
        DTPPlatformTests.assertNotNull((Object)database);
        String actual = database.getVersion();
        String expected = this.getDatabaseVersion();
        String errorMessage = "expected: " + expected + " - actual: " + actual;
        DTPPlatformTests.assertTrue((String)errorMessage, (actual.indexOf(expected) != -1 ? 1 : 0) != 0);
    }

    private void verifyDatabaseVendor() {
        Database database = this.connectionProfile.getDatabase();
        String actual = database.getVendorName();
        String expected = this.getDatabaseVendor();
        DTPPlatformTests.assertEquals((String)expected, (String)actual);
    }

    private void verifyDatabaseContent() {
        Database database = this.connectionProfile.getDatabase();
        DTPPlatformTests.assertTrue((database.getSchemataSize() >= 0 ? 1 : 0) != 0);
        Schema schema = database.getDefaultSchema();
        if (schema != null && schema.getTablesSize() > 0) {
            Table table = (Table)schema.getTables().iterator().next();
            DTPPlatformTests.assertTrue((table.getColumnsSize() >= 0 ? 1 : 0) != 0);
            DTPPlatformTests.assertTrue((table.getPrimaryKeyColumnsSize() >= 0 ? 1 : 0) != 0);
            DTPPlatformTests.assertTrue((table.getForeignKeysSize() >= 0 ? 1 : 0) != 0);
        }
    }

    protected abstract boolean executeOfflineTests();

    public final void testOffline() {
        if (!this.executeOfflineTests()) {
            return;
        }
        if (!this.connectionProfile.supportsWorkOfflineMode()) {
            return;
        }
        this.prepareForOfflineWork();
        IStatus status = this.connectionProfile.workOffline();
        DTPPlatformTests.assertTrue((boolean)status.isOK());
        DTPPlatformTests.assertTrue((boolean)this.connectionProfile.isActive());
        DTPPlatformTests.assertTrue((boolean)this.connectionProfile.isWorkingOffline());
        this.connectionProfile.disconnect();
        DTPPlatformTests.assertTrue((boolean)this.connectionProfile.isInactive());
        DTPPlatformTests.assertTrue((boolean)this.connectionProfile.isDisconnected());
    }

    protected void prepareForOfflineWork() {
        if (!this.connectionProfile.canWorkOffline()) {
            this.connectionProfile.connect();
            IStatus status = this.connectionProfile.saveWorkOfflineData();
            DTPPlatformTests.assertTrue((boolean)status.isOK());
            this.connectionProfile.disconnect();
            DTPPlatformTests.assertTrue((boolean)this.connectionProfile.canWorkOffline());
        }
    }

    public void testConnectionListenerConnect() {
        DTPPlatformTests.assertTrue((boolean)this.connectionProfileHasNoListeners());
        TestConnectionListener listener = new TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        DTPPlatformTests.assertTrue((boolean)this.connectionProfileHasAnyListeners());
        this.connectionProfile.connect();
        DTPPlatformTests.assertSame((Object)this.connectionProfile, (Object)listener.openedProfile);
        listener.clear();
        this.connectionProfile.disconnect();
        DTPPlatformTests.assertSame((Object)this.connectionProfile, (Object)listener.okToCloseProfile);
        DTPPlatformTests.assertSame((Object)this.connectionProfile, (Object)listener.aboutToCloseProfile);
        DTPPlatformTests.assertSame((Object)this.connectionProfile, (Object)listener.closedProfile);
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        DTPPlatformTests.assertTrue((boolean)this.connectionProfileHasNoListeners());
    }

    public final void testConnectionListenerOffline() {
        if (!this.executeOfflineTests()) {
            return;
        }
        TestConnectionListener listener = new TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        this.prepareForOfflineWork();
        listener.clear();
        this.connectionProfile.workOffline();
        DTPPlatformTests.assertSame((Object)this.connectionProfile, (Object)listener.openedProfile);
        listener.clear();
        this.connectionProfile.disconnect();
        DTPPlatformTests.assertSame((Object)this.connectionProfile, (Object)listener.okToCloseProfile);
        DTPPlatformTests.assertSame((Object)this.connectionProfile, (Object)listener.aboutToCloseProfile);
        DTPPlatformTests.assertSame((Object)this.connectionProfile, (Object)listener.closedProfile);
        listener.clear();
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
    }

    public void testConnectionListenerDatabase() {
        this.connectionProfile.connect();
        TestConnectionListener listener = new TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        ((ICatalogObject)this.getDTPDatabase()).refresh();
        DTPPlatformTests.assertSame((Object)this.connectionProfile.getDatabase(), (Object)listener.changedDatabase);
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    public void testConnectionListenerCatalog() {
        this.connectionProfile.connect();
        if (!this.connectionProfile.getDatabase().supportsCatalogs()) {
            this.connectionProfile.disconnect();
            return;
        }
        TestConnectionListener listener = new TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        org.eclipse.datatools.modelbase.sql.schema.Catalog dtpCatalog = this.getFirstDTPCatalog();
        Catalog catalog = this.getCatalogNamed(dtpCatalog.getName());
        ((ICatalogObject)dtpCatalog).refresh();
        DTPPlatformTests.assertSame((Object)catalog, (Object)listener.changedCatalog);
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    public void testConnectionListenerSchema() {
        this.connectionProfile.connect();
        TestConnectionListener listener = new TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        List<org.eclipse.datatools.modelbase.sql.schema.Catalog> dtpCatalogs = this.getDTPCatalogs();
        org.eclipse.datatools.modelbase.sql.schema.Catalog dtpCatalog = null;
        org.eclipse.datatools.modelbase.sql.schema.Schema dtpSchema = null;
        Schema schema = null;
        if (this.connectionProfile.getDatabase().supportsCatalogs()) {
            dtpCatalog = dtpCatalogs.get(0);
            dtpSchema = (org.eclipse.datatools.modelbase.sql.schema.Schema)dtpCatalog.getSchemas().get(0);
            schema = this.getCatalogNamed(dtpCatalog.getName()).getSchemaNamed(dtpSchema.getName());
        } else if (dtpCatalogs.isEmpty()) {
            dtpSchema = (org.eclipse.datatools.modelbase.sql.schema.Schema)this.getDTPDatabase().getSchemas().get(0);
            schema = this.connectionProfile.getDatabase().getSchemaNamed(dtpSchema.getName());
        } else {
            dtpCatalog = dtpCatalogs.get(0);
            DTPPlatformTests.assertEquals((String)DB_PASSWORD_DEFAULT, (String)dtpCatalog.getName());
            dtpSchema = (org.eclipse.datatools.modelbase.sql.schema.Schema)dtpCatalog.getSchemas().get(0);
            schema = this.getDatabase().getSchemaNamed(dtpSchema.getName());
        }
        DTPPlatformTests.assertTrue((schema.getTablesSize() >= 0 ? 1 : 0) != 0);
        ((ICatalogObject)dtpSchema).refresh();
        DTPPlatformTests.assertSame((Object)schema, (Object)listener.changedSchema);
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    public void testSupportsCatalogs() {
        this.connectionProfile.connect();
        TestConnectionListener listener = new TestConnectionListener();
        this.connectionProfile.addConnectionListener((ConnectionListener)listener);
        boolean supportsCatalogs = this.supportsCatalogs();
        DTPPlatformTests.assertEquals((boolean)supportsCatalogs, (boolean)this.connectionProfile.getDatabase().supportsCatalogs());
        if (supportsCatalogs) {
            DTPPlatformTests.assertTrue((this.connectionProfile.getDatabase().getCatalogsSize() > 0 ? 1 : 0) != 0);
            DTPPlatformTests.assertEquals((int)0, (int)this.connectionProfile.getDatabase().getSchemataSize());
        } else {
            DTPPlatformTests.assertEquals((int)0, (int)this.connectionProfile.getDatabase().getCatalogsSize());
            DTPPlatformTests.assertTrue((this.connectionProfile.getDatabase().getSchemataSize() > 0 ? 1 : 0) != 0);
        }
        this.connectionProfile.removeConnectionListener((ConnectionListener)listener);
        this.connectionProfile.disconnect();
    }

    protected abstract boolean supportsCatalogs();

    protected ConnectionProfileFactory getConnectionProfileFactory() {
        return (ConnectionProfileFactory)ResourcesPlugin.getWorkspace().getAdapter(ConnectionProfileFactory.class);
    }

    protected ConnectionProfile getConnectionProfile() {
        return this.connectionProfile;
    }

    protected Database getDatabase() {
        return this.connectionProfile.getDatabase();
    }

    protected Catalog getDefaultCatalog() {
        return this.getDatabase().getDefaultCatalog();
    }

    protected Schema getDefaultSchema() {
        return this.getDatabase().getDefaultSchema();
    }

    protected Catalog getCatalogNamed(String catalogName) {
        return this.connectionProfile.getDatabase().getCatalogNamed(catalogName);
    }

    protected String getRequiredPlatformProperty(String propertyKey) {
        String propertyValue = this.platformProperties.getProperty(propertyKey);
        if (StringTools.isBlank((String)propertyValue)) {
            throw new IllegalArgumentException("The database platform properties file '" + this.getPlatformPropertiesFilePath() + "' is missing a value for the property '" + propertyKey + "'.");
        }
        return propertyValue;
    }

    protected boolean connectionProfileHasAnyListeners() {
        return DTPPlatformTests.connectionProfileHasAnyListeners(this.connectionProfile);
    }

    protected static boolean connectionProfileHasAnyListeners(ConnectionProfile cp) {
        return (Boolean)ObjectTools.execute((Object)cp, (String)"hasAnyListeners");
    }

    protected boolean connectionProfileHasNoListeners() {
        return DTPPlatformTests.connectionProfileHasNoListeners(this.connectionProfile);
    }

    protected static boolean connectionProfileHasNoListeners(ConnectionProfile cp) {
        return (Boolean)ObjectTools.execute((Object)cp, (String)"hasNoListeners");
    }

    protected ProfileManager getDTPProfileManager() {
        return ProfileManager.getInstance();
    }

    protected IConnectionProfile getDTPConnectionProfile() {
        return DTPPlatformTests.getDTPConnectionProfile(this.connectionProfile);
    }

    protected static IConnectionProfile getDTPConnectionProfile(ConnectionProfile cp) {
        return (IConnectionProfile)ObjectTools.get((Object)cp, (String)"dtpConnectionProfile");
    }

    protected org.eclipse.datatools.modelbase.sql.schema.Database getDTPDatabase() {
        return this.extractDTPDatabase(this.connectionProfile.getDatabase());
    }

    protected org.eclipse.datatools.modelbase.sql.schema.Database extractDTPDatabase(Database database) {
        return (org.eclipse.datatools.modelbase.sql.schema.Database)this.extractDTPObject((DatabaseObject)database);
    }

    protected Object extractDTPObject(DatabaseObject databaseObject) {
        return ObjectTools.get((Object)databaseObject, (String)"dtpObject");
    }

    protected List<org.eclipse.datatools.modelbase.sql.schema.Catalog> getDTPCatalogs() {
        return this.getDTPDatabase().getCatalogs();
    }

    protected org.eclipse.datatools.modelbase.sql.schema.Catalog getFirstDTPCatalog() {
        return this.getDTPCatalogs().get(0);
    }

    protected org.eclipse.datatools.modelbase.sql.schema.Catalog getDTPCatalogNamed(String name) {
        return this.extractDTPCatalog(this.getDatabase().getCatalogNamed(name));
    }

    protected org.eclipse.datatools.modelbase.sql.schema.Catalog extractDTPCatalog(Catalog catalog) {
        return (org.eclipse.datatools.modelbase.sql.schema.Catalog)this.extractDTPObject((DatabaseObject)catalog);
    }

    protected org.eclipse.datatools.modelbase.sql.schema.Schema getDTPSchemaNamed(String name) {
        return this.extractDTPSchema(this.getDatabase().getSchemaNamed(name));
    }

    protected org.eclipse.datatools.modelbase.sql.schema.Schema extractDTPSchema(Schema schema) {
        return (org.eclipse.datatools.modelbase.sql.schema.Schema)this.extractDTPObject((DatabaseObject)schema);
    }

    protected void executeUpdateIgnoreErrors(String sql) {
        try {
            this.executeUpdate(sql);
        }
        catch (Exception exception) {}
    }

    protected void executeUpdate(String sql) throws SQLException {
        try (Statement jdbcStatement = this.createJDBCStatement();){
            jdbcStatement.executeUpdate(sql);
        }
    }

    protected void dump(String sql) throws Exception {
        this.dump(sql, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(String sql, int columnWidth) throws Exception {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)new OutputStreamWriter(System.out));
        PrintStream printStream = System.out;
        synchronized (printStream) {
            this.dumpOn(sql, pw, columnWidth);
        }
        pw.flush();
        pw.close();
    }

    protected void dumpOn(String sql, IndentingPrintWriter pw, int columnWidth) throws Exception {
        pw.println(sql);
        for (Map<String, Object> row : this.execute(sql)) {
            for (Map.Entry<String, Object> field : row.entrySet()) {
                WriterTools.fit((Writer)pw, (String)String.valueOf(field.getKey()), (int)(columnWidth / 2));
                pw.print('=');
                WriterTools.fit((Writer)pw, (String)String.valueOf(field.getValue()), (int)(columnWidth / 2));
                pw.print(' ');
            }
            pw.println();
        }
    }

    protected List<Map<String, Object>> execute(String sql) throws SQLException {
        return ConnectionTools.execute((Connection)this.getJDBCConnection(), (String)sql);
    }

    protected Statement createJDBCStatement() throws SQLException {
        return this.getJDBCConnection().createStatement();
    }

    protected Connection getJDBCConnection() {
        return this.connectionProfile.getJDBCConnection();
    }

    protected DatabaseMetaData getDatabaseMetaData() throws SQLException {
        return this.getJDBCConnection().getMetaData();
    }

    protected void dumpDatabase() {
        this.dumpDatabase(true);
    }

    protected void dumpDatabaseContainers() {
        this.dumpDatabase(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpDatabase(boolean deep) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)new OutputStreamWriter(System.out));
        PrintStream printStream = System.out;
        synchronized (printStream) {
            this.dumpDatabaseOn(pw, deep);
        }
        pw.flush();
        pw.close();
    }

    protected void dumpDatabaseOn(IndentingPrintWriter pw, boolean deep) {
        Database database = this.connectionProfile.getDatabase();
        pw.print("database: ");
        pw.println(database.getName());
        if (database.supportsCatalogs()) {
            for (Catalog catalog : database.getCatalogs()) {
                this.dumpCatalogOn(catalog, pw, deep);
            }
        } else {
            this.dumpSchemaContainerOn((SchemaContainer)database, pw, deep);
        }
    }

    protected void dumpCatalogOn(Catalog catalog, IndentingPrintWriter pw, boolean deep) {
        pw.print("catalog: ");
        pw.println(catalog.getName());
        pw.indent();
        this.dumpSchemaContainerOn((SchemaContainer)catalog, pw, deep);
        pw.undent();
    }

    protected void dumpSchemaContainerOn(SchemaContainer schemaContainer, IndentingPrintWriter pw, boolean deep) {
        for (Schema schema : schemaContainer.getSchemata()) {
            this.dumpSchemaOn(schema, pw, deep);
        }
    }

    protected void dumpSchema(Schema schema) {
        this.dumpSchema(schema, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpSchema(Schema schema, boolean deep) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)new OutputStreamWriter(System.out));
        PrintStream printStream = System.out;
        synchronized (printStream) {
            this.dumpSchemaOn(schema, pw, deep);
        }
        pw.flush();
        pw.close();
    }

    protected void dumpSchemaOn(Schema schema, IndentingPrintWriter pw, boolean deep) {
        pw.print("schema: ");
        pw.println(schema.getName());
        if (deep) {
            pw.indent();
            for (Table table : schema.getTables()) {
                this.dumpTableOn(table, pw);
            }
            for (Sequence sequence : schema.getSequences()) {
                this.dumpSequenceOn(sequence, pw);
            }
            pw.undent();
        }
    }

    protected void dumpTableOn(Table table, IndentingPrintWriter pw) {
        pw.print("table: ");
        pw.println(table.getName());
        pw.indent();
        for (Column column : table.getColumns()) {
            this.dumpColumnOn(column, pw);
        }
        for (ForeignKey foreignKey : table.getForeignKeys()) {
            this.dumpForeignKeyOn(foreignKey, pw);
        }
        pw.undent();
    }

    protected void dumpColumnOn(Column column, IndentingPrintWriter pw) {
        pw.print("column: ");
        pw.print(column.getName());
        pw.print(" : ");
        pw.print(column.getDataTypeName());
        if (column.isPartOfPrimaryKey()) {
            pw.print(" [primary key]");
        }
        pw.println();
    }

    protected void dumpForeignKeyOn(ForeignKey foreignKey, IndentingPrintWriter pw) {
        pw.print("foreign key: ");
        pw.print(foreignKey.getName());
        pw.print("=>");
        pw.print(foreignKey.getReferencedTable().getName());
        pw.print(" (");
        Iterator stream = foreignKey.getColumnPairs().iterator();
        while (stream.hasNext()) {
            ForeignKey.ColumnPair cp = (ForeignKey.ColumnPair)stream.next();
            pw.print(cp.getBaseColumn().getName());
            pw.print("=>");
            pw.print(cp.getReferencedColumn().getName());
            if (!stream.hasNext()) continue;
            pw.print(", ");
        }
        pw.print(')');
        pw.println();
    }

    protected void dumpSequenceOn(Sequence sequence, IndentingPrintWriter pw) {
        pw.print("sequence: ");
        pw.println(sequence.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpJDBCCatalogs() throws SQLException {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)new OutputStreamWriter(System.out));
        PrintStream printStream = System.out;
        synchronized (printStream) {
            this.dumpJDBCCatalogsOn(pw);
        }
        pw.flush();
        pw.close();
    }

    protected void dumpJDBCCatalogsOn(IndentingPrintWriter pw) throws SQLException {
        pw.println("JDBC catalogs: ");
        pw.indent();
        ArrayList rows = ResultSetTools.convertToMaps((ResultSet)this.getDatabaseMetaData().getCatalogs());
        for (Map row : rows) {
            pw.println(row.get("TABLE_CAT"));
        }
        pw.undent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpJDBCSchemata() throws SQLException {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)new OutputStreamWriter(System.out));
        PrintStream printStream = System.out;
        synchronized (printStream) {
            this.dumpJDBCSchemataOn(pw);
        }
        pw.flush();
        pw.close();
    }

    protected void dumpJDBCSchemataOn(IndentingPrintWriter pw) throws SQLException {
        pw.println("JDBC schemata: ");
        pw.indent();
        ArrayList rows = ResultSetTools.convertToMaps((ResultSet)this.getDatabaseMetaData().getSchemas());
        for (Map row : rows) {
            if (row.size() == 2) {
                Object catalog = row.get("TABLE_CATALOG");
                pw.print(catalog);
                pw.print('.');
            }
            Object schema = row.get("TABLE_SCHEM");
            pw.println(schema);
        }
        pw.undent();
    }

    protected static class TestConnectionListener
    implements ConnectionListener {
        public ConnectionProfile openedProfile;
        public ConnectionProfile modifiedProfile;
        public ConnectionProfile okToCloseProfile;
        public ConnectionProfile aboutToCloseProfile;
        public ConnectionProfile closedProfile;
        public Database changedDatabase;
        public Catalog changedCatalog;
        public Schema changedSchema;
        public Sequence changedSequence;
        public Table changedTable;
        public Column changedColumn;
        public ForeignKey changedForeignKey;

        protected TestConnectionListener() {
        }

        public void opened(ConnectionProfile profile) {
            this.openedProfile = profile;
        }

        public void modified(ConnectionProfile profile) {
            this.modifiedProfile = profile;
        }

        public boolean okToClose(ConnectionProfile profile) {
            this.okToCloseProfile = profile;
            return true;
        }

        public void aboutToClose(ConnectionProfile profile) {
            this.aboutToCloseProfile = profile;
        }

        public void closed(ConnectionProfile profile) {
            this.closedProfile = profile;
        }

        public void databaseChanged(ConnectionProfile profile, Database database) {
            this.changedDatabase = database;
        }

        public void catalogChanged(ConnectionProfile profile, Catalog catalog) {
            this.changedCatalog = catalog;
        }

        public void schemaChanged(ConnectionProfile profile, Schema schema) {
            this.changedSchema = schema;
        }

        public void sequenceChanged(ConnectionProfile profile, Sequence sequence) {
            this.changedSequence = sequence;
        }

        public void tableChanged(ConnectionProfile profile, Table table) {
            this.changedTable = table;
        }

        public void columnChanged(ConnectionProfile profile, Column column) {
            this.changedColumn = column;
        }

        public void foreignKeyChanged(ConnectionProfile profile, ForeignKey foreignKey) {
            this.changedForeignKey = foreignKey;
        }

        public void clear() {
            this.openedProfile = null;
            this.modifiedProfile = null;
            this.okToCloseProfile = null;
            this.aboutToCloseProfile = null;
            this.closedProfile = null;
            this.changedDatabase = null;
            this.changedCatalog = null;
            this.changedSchema = null;
            this.changedSequence = null;
            this.changedTable = null;
            this.changedColumn = null;
            this.changedForeignKey = null;
        }
    }

    protected static class TestConnectionProfileListener
    extends ConnectionProfileAdapter {
        public String addedName;
        public String removedName;
        public String renamedOldName;
        public String renamedNewName;

        protected TestConnectionProfileListener() {
        }

        public void connectionProfileAdded(String name) {
            this.addedName = name;
        }

        public void connectionProfileRemoved(String name) {
            this.removedName = name;
        }

        public void connectionProfileRenamed(String oldName, String newName) {
            this.renamedOldName = oldName;
            this.renamedNewName = newName;
        }

        public void clear() {
            this.addedName = null;
            this.removedName = null;
            this.renamedOldName = null;
            this.renamedNewName = null;
        }
    }
}

