/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import junit.framework.Assert;
import org.eclipse.wst.jsdt.chromium.internal.transport.LineReader;
import org.eclipse.wst.jsdt.chromium.internal.transport.Message;
import org.junit.Test;

public class LineReaderTest {
    private static final Message[] SAMPLES_MESSAGES = new Message[]{new Message(LineReaderTest.createHeader(new String[0]), "Test"), new Message(LineReaderTest.createHeader("To", "peter", "From", "google"), "\u041f\u0440\u0438\u0432\u0435\u0442!"), new Message(LineReaderTest.createHeader("Tool", "DevToolsService", "Destination", "2"), "{variable={\"name\": \"result\", \"value\": \"\u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\"}}"), new Message(LineReaderTest.createHeader("To", "abcde@ttt.com", "From", "a"), "This is just a test"), new Message(LineReaderTest.createHeader("To", "peter", "From", "google"), "\u041f\u0440\u0438\u0432\u0435\u0442!"), new Message(LineReaderTest.createHeader("To", "\u041f\u0430\u0448\u0430@gmail.com", "From", "vikings@gmail.com"), "\u0421\u043f\u0430\u043c! Spam! \u0421\u043f\u0430\u043c! Spam!")};

    @Test
    public void testOnRandomChunkStream() throws IOException, Message.MalformedMessageException {
        Random random = new Random(0L);
        Charset charset = Charset.forName("UTF-8");
        int j = 0;
        while (j < 50) {
            Message nextMessage;
            ArrayList<Message> messages = new ArrayList<Message>(Arrays.asList(SAMPLES_MESSAGES));
            Collections.shuffle(messages, random);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (Message message : messages) {
                message.sendThrough((OutputStream)byteArrayOutputStream, charset);
            }
            byte[] bytes = byteArrayOutputStream.toByteArray();
            MultiChunkInputStream inputStream = new MultiChunkInputStream(bytes, random);
            LineReader lineReader = new LineReader((InputStream)inputStream);
            ArrayList<Message> reReadMessages = new ArrayList<Message>();
            while ((nextMessage = Message.fromBufferedReader((LineReader)lineReader, (Charset)charset)) != null) {
                reReadMessages.add(nextMessage);
            }
            Assert.assertEquals((int)messages.size(), (int)reReadMessages.size());
            int i = 0;
            while (i < messages.size()) {
                Assert.assertEquals((String)((Message)messages.get(i)).toString(), (String)((Message)reReadMessages.get(i)).toString());
                ++i;
            }
            ++j;
        }
    }

    private static Map<String, String> createHeader(String ... keyAndValuePairs) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < keyAndValuePairs.length) {
            result.put(keyAndValuePairs[i], keyAndValuePairs[i + 1]);
            i += 2;
        }
        return result;
    }

    private static class MultiChunkInputStream
    extends InputStream {
        private static final int CHUNK_MAX_SIZE = 17;
        private final byte[] bytes;
        private final Random random;
        private int pos = 0;
        private int nextChunkEnd;

        MultiChunkInputStream(byte[] bytes, Random random) {
            this.bytes = bytes;
            this.random = random;
            this.pos = 0;
            this.planNextChunk();
        }

        @Override
        public int read() {
            if (this.pos >= this.bytes.length) {
                return -1;
            }
            return this.bytes[this.pos++];
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if (this.pos >= this.bytes.length) {
                return -1;
            }
            if (this.pos >= this.nextChunkEnd) {
                this.planNextChunk();
            }
            len = Math.min(len, Math.min(this.nextChunkEnd, this.bytes.length) - this.pos);
            System.arraycopy(this.bytes, this.pos, b, off, len);
            this.pos += len;
            return len;
        }

        private void planNextChunk() {
            this.nextChunkEnd = this.pos + 1 + this.random.nextInt(17);
        }
    }
}

