/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.reference;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.reference.BooleanReference;

public abstract class BooleanReferenceTests
extends TestCase {
    public BooleanReferenceTests(String name) {
        super(name);
    }

    protected BooleanReference buildBooleanReference() {
        return this.buildBooleanReference(true);
    }

    protected abstract BooleanReference buildBooleanReference(boolean var1);

    public void testGetValue() {
        BooleanReference br = this.buildBooleanReference();
        BooleanReferenceTests.assertTrue((boolean)br.getValue());
    }

    public void testIs() {
        BooleanReference br = this.buildBooleanReference();
        BooleanReferenceTests.assertTrue((boolean)br.is(true));
        BooleanReferenceTests.assertFalse((boolean)br.is(false));
    }

    public void testIsNot() {
        BooleanReference br = this.buildBooleanReference();
        BooleanReferenceTests.assertFalse((boolean)br.isNot(true));
        BooleanReferenceTests.assertTrue((boolean)br.isNot(false));
    }

    public void testIsTrue() {
        BooleanReference br = this.buildBooleanReference();
        BooleanReferenceTests.assertTrue((boolean)br.isTrue());
    }

    public void testIsFalse() {
        BooleanReference br = this.buildBooleanReference();
        BooleanReferenceTests.assertFalse((boolean)br.isFalse());
        br = this.buildBooleanReference(false);
        BooleanReferenceTests.assertTrue((boolean)br.isFalse());
    }

    public void testEquals() {
        BooleanReference br1 = this.buildBooleanReference();
        BooleanReference br2 = this.buildBooleanReference();
        BooleanReferenceTests.assertTrue((boolean)br1.equals(br1));
        BooleanReferenceTests.assertFalse((boolean)br1.equals(br2));
    }

    public void testHashCode() {
        BooleanReference br = this.buildBooleanReference();
        BooleanReferenceTests.assertEquals((int)br.hashCode(), (int)br.hashCode());
    }

    public void testToString() {
        BooleanReference br = this.buildBooleanReference(true);
        BooleanReferenceTests.assertEquals((String)"[true]", (String)br.toString());
        br = this.buildBooleanReference(false);
        BooleanReferenceTests.assertEquals((String)"[false]", (String)br.toString());
    }
}

