/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.RuntimeExceptionWrapper;

public class Results
implements Serializable {
    private static final long serialVersionUID = -2722051869610289637L;
    private int callCount;
    private LinkedList<Range> ranges = new LinkedList();
    private List<Result> results = new ArrayList<Result>();

    public void add(Result result, Range range) {
        Range lastRange;
        if (!this.ranges.isEmpty() && !(lastRange = this.ranges.getLast()).hasFixedCount()) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("last method called on mock already has a non-fixed count set."));
        }
        this.ranges.add(range);
        this.results.add(result);
    }

    public Result next() {
        int currentPosition = 0;
        for (int i = 0; i < this.ranges.size(); ++i) {
            Range interval = this.ranges.get(i);
            if (interval.hasOpenCount()) {
                ++this.callCount;
                return this.results.get(i);
            }
            if ((currentPosition += interval.getMaximum()) <= this.callCount) continue;
            ++this.callCount;
            return this.results.get(i);
        }
        return null;
    }

    public boolean hasValidCallCount() {
        return this.getMainInterval().contains(this.getCallCount());
    }

    public String toString() {
        return this.getMainInterval().expectedAndActual(this.getCallCount());
    }

    private Range getMainInterval() {
        int min = 0;
        int max = 0;
        for (Range interval : this.ranges) {
            min += interval.getMinimum();
            if (interval.hasOpenCount() || max == Integer.MAX_VALUE) {
                max = Integer.MAX_VALUE;
                continue;
            }
            max += interval.getMaximum();
        }
        return new Range(min, max);
    }

    public int getCallCount() {
        return this.callCount;
    }
}

