/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util;

import java.lang.reflect.InvocationTargetException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class ProjectTestEnvironment {
    protected boolean _projectCreated = false;
    protected final String _projectName;
    protected IProject _project;
    protected static final IOverwriteQuery OVERWRITE_ALL_QUERY = new IOverwriteQuery(){

        public String queryOverwrite(String pathString) {
            return "ALL";
        }
    };

    public ProjectTestEnvironment(String projectName) {
        this._projectName = projectName;
    }

    public boolean isProjectCreated() {
        return this._projectCreated;
    }

    public boolean createProject(boolean ignoreProjectExists) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this._projectName);
        if (project.isAccessible() && !ignoreProjectExists) {
            throw new RuntimeException("Project was not expected to exist but does: " + project.getName());
        }
        if (!this.isProjectCreated()) {
            this.deleteProject();
            if (!project.exists()) {
                try {
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    project.create((IProgressMonitor)monitor);
                    project.open((IProgressMonitor)monitor);
                    this._project = project;
                    this._projectCreated = true;
                    return true;
                }
                catch (CoreException ce) {
                    ce.printStackTrace();
                }
            }
        }
        return false;
    }

    public final void createFromZip(ZipFile projectZip, boolean ignoreProjectExists) throws InvocationTargetException, InterruptedException {
        this.createProject(ignoreProjectExists);
        ZipFileStructureProvider zipFileStructureProvider = new ZipFileStructureProvider(projectZip){

            public String getFullPath(Object element) {
                String fullName = super.getFullPath(element);
                Path asPath = new Path(fullName);
                if (asPath.segmentCount() > 0) {
                    boolean pathIsAbsolute = asPath.isAbsolute();
                    String newFirstSegment = String.valueOf(pathIsAbsolute ? "/" : "") + ProjectTestEnvironment.this._projectName;
                    asPath = new Path(String.valueOf(newFirstSegment) + "/" + asPath.removeFirstSegments(1).toString());
                }
                return asPath.toString();
            }

            public String getLabel(Object element) {
                if (element.equals(this.getRoot())) {
                    return ((ZipEntry)element).getName();
                }
                return new Path(this.getFullPath(element)).lastSegment();
            }
        };
        ImportOperation op = new ImportOperation(this._project.getProjectRelativePath(), (Object)zipFileStructureProvider.getRoot(), (IImportStructureProvider)zipFileStructureProvider, OVERWRITE_ALL_QUERY);
        op.setCreateContainerStructure(true);
        op.run(null);
    }

    public final void createFromZip2(ZipFile projectZip, boolean ignoreProjectExists) throws InvocationTargetException, InterruptedException {
        this.createProject(ignoreProjectExists);
        ZipFileStructureProvider zipFileStructureProvider = new ZipFileStructureProvider(projectZip);
        ImportOperation op = new ImportOperation(this._project.getFullPath(), (Object)zipFileStructureProvider.getRoot(), (IImportStructureProvider)zipFileStructureProvider, OVERWRITE_ALL_QUERY);
        op.setCreateContainerStructure(true);
        op.run(null);
    }

    public void deleteProject() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject oldWebProj = workspace.getRoot().getProject(this._projectName);
        try {
            if (oldWebProj != null && oldWebProj.isAccessible()) {
                workspace.delete(new IResource[]{oldWebProj}, true, null);
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    public void setProjectDirtied() {
        this._projectCreated = false;
    }

    public void recreateProject() {
        this.setProjectDirtied();
        this.createProject(true);
    }

    public IProject getTestProject() {
        if (this._projectCreated) {
            return this._project;
        }
        return null;
    }
}

