/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.tests.internal.annotations;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.ws.jaxws.testutils.project.ClassLoadingTest;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationGeneratorException;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationWriter;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;
import org.eclipse.jst.ws.jaxws.utils.annotations.IValue;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.ArrayValueImpl;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.BooleanValueImpl;

public class BooleanValueImplTest
extends ClassLoadingTest {
    private static final String SRC = "src";
    private static final String PCK = "org.eclipse.demo";
    private IType endpoint;

    public void setUp() throws CoreException, IOException, AnnotationGeneratorException {
        this.createJavaProject(SRC, PCK);
        this.endpoint = this.createClass("Endpoint.src", "Endpoint");
        AnnotationFactory.removeAnnotationsFromJavaElement((IJavaElement)this.endpoint);
    }

    public void testBooleanValueImpl() {
        try {
            new ArrayValueImpl(null);
            BooleanValueImplTest.fail((String)"NullPointerException not thrown");
        }
        catch (NullPointerException nullPointerException) {
            BooleanValueImplTest.assertTrue((boolean)true);
        }
    }

    public void testBooleans() throws Exception {
        this.setUp();
        BooleanValueImpl bv = new BooleanValueImpl(true);
        HashSet<IParamValuePair> pv = new HashSet<IParamValuePair>();
        pv.add(AnnotationFactory.createParamValuePairValue((String)"param", (IValue)bv));
        IAnnotation ann = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyAnnotation", pv, (IJavaElement)this.endpoint);
        AnnotationWriter.getInstance().setAppliedElement(ann, (IJavaElement)this.endpoint);
        Collection annotattions = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType();
        BooleanValueImplTest.assertNotNull((Object)annotattions);
        BooleanValueImplTest.assertTrue((annotattions.size() == 1 ? 1 : 0) != 0);
        IAnnotation readAnnotation = (IAnnotation)annotattions.iterator().next();
        readAnnotation.equals(ann);
        AnnotationWriter.getInstance().remove(ann);
        annotattions = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType();
        BooleanValueImplTest.assertNotNull((Object)annotattions);
        BooleanValueImplTest.assertTrue((annotattions.size() == 0 ? 1 : 0) != 0);
    }

    public void testEqualsObject() {
        BooleanValueImpl bv1 = new BooleanValueImpl(true);
        BooleanValueImpl bv2 = new BooleanValueImpl(false);
        BooleanValueImpl bv3 = new BooleanValueImpl(true);
        BooleanValueImplTest.assertFalse((boolean)bv1.equals(null));
        BooleanValueImplTest.assertFalse((boolean)bv1.equals((Object)123));
        BooleanValueImplTest.assertFalse((boolean)bv1.equals((Object)bv2));
        BooleanValueImplTest.assertTrue((boolean)bv1.equals((Object)bv3));
        BooleanValueImplTest.assertTrue((boolean)bv1.equals((Object)bv1));
    }
}

