/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomFactory;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IDOM;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.ICompilationUnitHandler;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IModelElementSynchronizer;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync.SeiSynchronizer;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.sync.WsSynchronizer;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotationInspector;
import org.eclipse.jst.ws.jaxws.utils.logging.ILogger;

public abstract class AbstractModelSynchronizer
implements IModelElementSynchronizer {
    private final SeiSynchronizer seiLoader;
    private final WsSynchronizer wsLoader;
    private final JaxWsWorkspaceResource resource;
    private IDOM domBeingLoaded;
    private final JaxWsWorkspaceResource.ServiceModelData serviceData;
    private final DomUtil util;

    public AbstractModelSynchronizer(JaxWsWorkspaceResource resource, JaxWsWorkspaceResource.ServiceModelData serviceData) {
        this.resource = resource;
        this.util = new DomUtil();
        this.serviceData = serviceData;
        this.seiLoader = new SeiSynchronizer(this);
        this.wsLoader = new WsSynchronizer(this);
    }

    public DomFactory domFactory() {
        return DomFactory.eINSTANCE;
    }

    public IDOM getDomBeingLoaded() {
        if (this.domBeingLoaded == null) {
            this.domBeingLoaded = this.domFactory().createIDOM();
        }
        return this.domBeingLoaded;
    }

    public IJavaModel javaModel() {
        return this.resource.javaModel();
    }

    public ILogger logger() {
        return this.resource.logger();
    }

    public JaxWsWorkspaceResource resource() {
        return this.resource;
    }

    public JaxWsWorkspaceResource.ServiceModelData serviceData() {
        return this.serviceData;
    }

    public DomUtil util() {
        return this.util;
    }

    protected void processCompilationUnit(IWebServiceProject wsProject, ICompilationUnit cu) throws JavaModelException {
        try {
            this.resource.disableSaving();
            if (cu.findPrimaryType() == null || !cu.findPrimaryType().isInterface() && !cu.findPrimaryType().isClass()) {
                if (this.logger().isDebug()) {
                    this.logger().logDebug("no primary type in compilation unit" + cu.getPath().toOSString());
                }
                return;
            }
            IAnnotationInspector inspector = this.resource().newAnnotationInspector(cu.findPrimaryType());
            IAnnotation wsAnnotation = inspector.inspectType("javax.jws.WebService");
            if (wsAnnotation == null) {
                if (this.logger().isDebug()) {
                    this.logger().logDebug("no javax.jws.WebService annotation found on type " + cu.findPrimaryType().getFullyQualifiedName());
                }
                return;
            }
            this.recordHierarchy(cu.findPrimaryType());
            if (((IType)wsAnnotation.getAppliedElement()).isInterface()) {
                this.removeWsModelElements(wsProject, ((IType)wsAnnotation.getAppliedElement()).getFullyQualifiedName(), false);
                this.seiLoader.synchronizeInterface(wsProject, (IAnnotation<IType>)wsAnnotation, inspector);
            } else if (((IType)wsAnnotation.getAppliedElement()).isClass()) {
                this.removeSeiModelElements(wsProject, ((IType)wsAnnotation.getAppliedElement()).getFullyQualifiedName(), false, true);
                IWebService ws = this.wsLoader.synchronizeWebService(wsProject, (IAnnotation<IType>)wsAnnotation, inspector);
                if (!(ws == null || ws.getServiceEndpoint() != null && ws.getServiceEndpoint().isImplicit())) {
                    this.removeSeiModelElements(wsProject, ws.getImplementation(), false, false);
                }
            } else if (this.logger().isDebug()) {
                this.logger().logDebug("annotation javax.jws.WebService is put on type " + ((IType)wsAnnotation.getAppliedElement()).getFullyQualifiedName() + "which is neither interface, nor a class. Ignorring!");
            }
        }
        finally {
            this.resource.enableSaving();
        }
    }

    protected void removeWsModelElements(IWebServiceProject wsProject, String implBaseName, boolean isForPackage) {
        Iterator wsIter = wsProject.getWebServices().iterator();
        while (wsIter.hasNext()) {
            IWebService ws = (IWebService)wsIter.next();
            if (!ws.getImplementation().equals(implBaseName) && (!isForPackage || !ws.getImplementation().startsWith(implBaseName))) continue;
            this.serviceData().clearHierarchy(ws.getImplementation());
            wsIter.remove();
            if (ws.getServiceEndpoint() != null) {
                ws.getServiceEndpoint().getImplementingWebServices().remove((Object)ws);
            }
            this.serviceData().unmap(ws);
        }
    }

    protected void removeSeiModelElements(IWebServiceProject wsProject, String implBaseName, boolean isForPackage, boolean onlyExplicit) {
        Iterator seiIter = wsProject.getServiceEndpointInterfaces().iterator();
        while (seiIter.hasNext()) {
            IServiceEndpointInterface sei = (IServiceEndpointInterface)seiIter.next();
            if (!sei.getImplementation().equals(implBaseName) && (!isForPackage || !sei.getImplementation().startsWith(implBaseName)) || onlyExplicit && sei.isImplicit()) continue;
            this.serviceData().clearHierarchy(sei.getImplementation());
            sei.getImplementingWebServices().clear();
            seiIter.remove();
        }
    }

    void recordHierarchy(IType type) throws JavaModelException {
        LinkedList<ICompilationUnit> compilationUnits = new LinkedList<ICompilationUnit>();
        IType[] iTypeArray = type.newSupertypeHierarchy(null).getAllSupertypes(type);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType superType = iTypeArray[n2];
            compilationUnits.add(superType.getCompilationUnit());
            ++n2;
        }
        this.serviceData().recordHierarchy(type.getFullyQualifiedName(), compilationUnits);
    }

    protected IWebServiceProject createProject(IJavaProject jprj) {
        IWebServiceProject thisProject = this.domFactory().createIWebServiceProject();
        this.util().setFeatureValue(thisProject, 2, jprj.getElementName());
        this.util().addToCollectionFeature(this.getDomBeingLoaded(), 0, thisProject);
        return thisProject;
    }

    protected class LoaderCompilationUnitHandler
    implements ICompilationUnitHandler {
        protected IWebServiceProject wsProject;

        protected LoaderCompilationUnitHandler() {
        }

        public void started() {
        }

        public void finished() {
            AbstractModelSynchronizer.this.resource().getContents().add((Object)AbstractModelSynchronizer.this.getDomBeingLoaded());
        }

        public void handle(IJavaProject jprj) {
            this.wsProject = AbstractModelSynchronizer.this.createProject(jprj);
        }

        public void handle(ICompilationUnit cu) {
            try {
                AbstractModelSynchronizer.this.processCompilationUnit(this.wsProject, cu);
            }
            catch (JavaModelException jme) {
                AbstractModelSynchronizer.this.logger().logError("Unable to parse the content of compilation unit" + cu.getPath().toOSString(), (Throwable)jme);
            }
        }
    }
}

